/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DirectJMSConnectionFactoryInjectionSource
extends InjectionSource {
    private final String name;
    private String interfaceName;
    private String className;
    private String resourceAdapter;
    private String user;
    private String password;
    private String clientId;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean transactional;
    private int maxPoolSize;
    private int minPoolSize;

    public DirectJMSConnectionFactoryInjectionSource(String name) {
        this.name = name;
    }

    void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setUser(String user) {
        this.user = user;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        try {
            this.startedPooledConnectionFactory(context, this.name, serviceBuilder, phaseContext.getServiceTarget(), deploymentUnit, injector);
        }
        catch (OperationFailedException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startedPooledConnectionFactory(InjectionSource.ResolutionContext context, String name, ServiceBuilder<?> serviceBuilder, ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException, OperationFailedException {
        String string;
        String discoveryGroupName;
        HashMap<String, String> props = new HashMap<String, String>(this.properties);
        List<String> connectors = this.getConnectors(props);
        this.clearUnknownProperties(this.properties);
        ModelNode model = new ModelNode();
        for (String string2 : connectors) {
            model.get("connector").add(string2);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            model.get((String)entry.getKey()).set((String)entry.getValue());
        }
        model.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).set(this.minPoolSize);
        model.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).set(this.maxPoolSize);
        if (this.user != null && !this.user.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.USER.getName()).set(this.user);
        }
        if (this.password != null && !this.password.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.PASSWORD.getName()).set(this.password);
        }
        if (this.clientId != null && !this.clientId.isEmpty()) {
            model.get(CommonAttributes.CLIENT_ID.getName()).set(this.clientId);
        }
        String string3 = discoveryGroupName = this.properties.containsKey(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName()) ? this.properties.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName()) : null;
        if (discoveryGroupName != null) {
            model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName()).set(discoveryGroupName);
        }
        String string4 = string = this.properties.containsKey(CommonAttributes.JGROUPS_CHANNEL.getName()) ? this.properties.get(CommonAttributes.JGROUPS_CHANNEL.getName()) : null;
        if (string != null) {
            model.get(CommonAttributes.JGROUPS_CHANNEL.getName()).set(string);
        }
        List<PooledConnectionFactoryConfigProperties> adapterParams = this.getAdapterParams(model);
        String txSupport = this.transactional ? "XATransaction" : "NoTransaction";
        String pcfName = DirectJMSConnectionFactoryInjectionSource.uniqueName(context, name);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)name);
        PooledConnectionFactoryService.installService(null, null, serviceTarget, pcfName, this.getHornetQServerName(), connectors, discoveryGroupName, string, adapterParams, bindInfo, txSupport, this.minPoolSize, this.maxPoolSize, true);
        ServiceName referenceFactoryServiceName = ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
        serviceBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, injector);
        String managementName = DirectJMSConnectionFactoryInjectionSource.managementName(context, name);
        PathElement serverElement = PathElement.pathElement((String)"hornetq-server", (String)this.getHornetQServerName());
        deploymentUnit.createDeploymentSubModel("messaging", serverElement);
        PathElement pcfPath = PathElement.pathElement((String)"pooled-connection-factory", (String)managementName);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, pcfPath});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        PooledConnectionFactoryConfigurationRuntimeHandler.INSTANCE.registerResource(this.getHornetQServerName(), managementName, model);
    }

    private List<String> getConnectors(Map<String, String> props) {
        ArrayList<String> connectors = new ArrayList<String>();
        if (props.containsKey("connector")) {
            String connectorsStr = this.properties.remove("connector");
            for (String s : connectorsStr.split(",")) {
                String connector = s.trim();
                if (connector.isEmpty()) continue;
                connectors.add(connector);
            }
        }
        return connectors;
    }

    void clearUnknownProperties(Map<String, String> props) {
        Set<String> attributeNames = PooledConnectionFactoryDefinition.getAttributes().keySet();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String value = entry.getKey();
            if (value == null || "".equals(value)) {
                it.remove();
                continue;
            }
            if (attributeNames.contains(entry.getKey())) continue;
            MessagingLogger.MESSAGING_LOGGER.unknownPooledConnectionFactoryAttribute(entry.getKey());
            it.remove();
        }
    }

    private static String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        return uniqueName.append(context.getApplicationName() + "_").append(DirectJMSConnectionFactoryInjectionSource.managementName(context, jndiName)).toString();
    }

    private static String managementName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName() + "_");
        }
        return uniqueName.append(jndiName.replace(':', '_')).toString();
    }

    private List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model) {
        Map<String, ConnectionFactoryAttribute> attributes = PooledConnectionFactoryDefinition.getAttributes();
        ArrayList<PooledConnectionFactoryConfigProperties> props = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (Property property : model.asPropertyList()) {
            ConnectionFactoryAttribute attribute = attributes.get(property.getName());
            if (attribute.getPropertyName() == null) continue;
            props.add(new PooledConnectionFactoryConfigProperties(attribute.getPropertyName(), property.getValue().asString(), attribute.getClassType()));
        }
        return props;
    }

    private String getHornetQServerName() {
        return this.properties.containsKey("hornetq-server") ? this.properties.get("hornetq-server") : "default";
    }
}

