/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.AbstractQueueControlHandler;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class QueueControlHandler
extends AbstractQueueControlHandler<QueueControl> {
    public static final QueueControlHandler INSTANCE = new QueueControlHandler();
    public static final String LIST_SCHEDULED_MESSAGES = "list-scheduled-messages";
    public static final String LIST_SCHEDULED_MESSAGES_AS_JSON = "list-scheduled-messages-as-json";

    private QueueControlHandler() {
        super((ParameterValidator)new ModelTypeValidator(ModelType.LONG));
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        EnumSet<OperationEntry.Flag> flags = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(LIST_SCHEDULED_MESSAGES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListScheduledMessages(locale);
            }
        }, flags);
        registry.registerOperationHandler(LIST_SCHEDULED_MESSAGES_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, QueueControlHandler.LIST_SCHEDULED_MESSAGES_AS_JSON, "queue", ModelType.STRING, true);
            }
        }, flags);
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    @Override
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (QueueDefinition.forwardToRuntimeQueue(context, operation, (OperationStepHandler)INSTANCE)) {
            context.stepCompleted();
        } else {
            super.executeRuntimeStep(context, operation);
        }
    }

    @Override
    protected Object handleAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl) throws OperationFailedException {
        try {
            if (LIST_SCHEDULED_MESSAGES.equals(operationName)) {
                String json = queueControl.listScheduledMessagesAsJSON();
                context.getResult().set(ModelNode.fromJSONString((String)json));
            } else if (LIST_SCHEDULED_MESSAGES_AS_JSON.equals(operationName)) {
                context.getResult().set(queueControl.listScheduledMessagesAsJSON());
            } else {
                this.throwUnimplementedOperationException(operationName);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    protected void revertAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl, Object handback) {
    }

    @Override
    public boolean isJMS() {
        return false;
    }

    @Override
    protected AbstractQueueControlHandler.DelegatingQueueControl<QueueControl> getQueueControl(HornetQServer hqServer, String queueName) {
        final QueueControl control = (QueueControl)QueueControl.class.cast(hqServer.getManagementService().getResource("core.queue." + queueName));
        return new AbstractQueueControlHandler.DelegatingQueueControl<QueueControl>(){

            @Override
            public QueueControl getDelegate() {
                return control;
            }

            @Override
            public String listMessagesAsJSON(String filter) throws Exception {
                return control.listMessagesAsJSON(filter);
            }

            @Override
            public long countMessages(String filter) throws Exception {
                return control.countMessages(filter);
            }

            @Override
            public boolean removeMessage(ModelNode id) throws Exception {
                return control.removeMessage(id.asLong());
            }

            @Override
            public int removeMessages(String filter) throws Exception {
                return control.removeMessages(filter);
            }

            @Override
            public int expireMessages(String filter) throws Exception {
                return control.expireMessages(filter);
            }

            @Override
            public boolean expireMessage(ModelNode id) throws Exception {
                return control.expireMessage(id.asLong());
            }

            @Override
            public boolean sendMessageToDeadLetterAddress(ModelNode id) throws Exception {
                return control.sendMessageToDeadLetterAddress(id.asLong());
            }

            @Override
            public int sendMessagesToDeadLetterAddress(String filter) throws Exception {
                return control.sendMessagesToDeadLetterAddress(filter);
            }

            @Override
            public boolean changeMessagePriority(ModelNode id, int priority) throws Exception {
                return control.changeMessagePriority(id.asLong(), priority);
            }

            @Override
            public int changeMessagesPriority(String filter, int priority) throws Exception {
                return control.changeMessagesPriority(filter, priority);
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue) throws Exception {
                return control.moveMessage(id.asLong(), otherQueue);
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue, boolean rejectDuplicates) throws Exception {
                return control.moveMessage(id.asLong(), otherQueue, rejectDuplicates);
            }

            @Override
            public int moveMessages(String filter, String otherQueue) throws Exception {
                return control.moveMessages(filter, otherQueue);
            }

            @Override
            public int moveMessages(String filter, String otherQueue, boolean rejectDuplicates) throws Exception {
                return control.moveMessages(filter, otherQueue, rejectDuplicates);
            }

            @Override
            public String listMessageCounter() throws Exception {
                return control.listMessageCounter();
            }

            @Override
            public void resetMessageCounter() throws Exception {
                control.resetMessageCounter();
            }

            @Override
            public String listMessageCounterAsHTML() throws Exception {
                return control.listMessageCounterAsHTML();
            }

            @Override
            public String listMessageCounterHistory() throws Exception {
                return control.listMessageCounterHistory();
            }

            @Override
            public String listMessageCounterHistoryAsHTML() throws Exception {
                return control.listMessageCounterHistoryAsHTML();
            }

            @Override
            public void pause() throws Exception {
                control.pause();
            }

            @Override
            public void resume() throws Exception {
                control.resume();
            }

            @Override
            public String listConsumersAsJSON() throws Exception {
                return control.listConsumersAsJSON();
            }
        };
    }
}

