/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.BinderServiceUtil;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.JGroupsChannelLocator;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.AS7RecoveryRegistry;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.TransactionManagerLocator;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.v10.CommonConnDef;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.Messageadapter;
import org.jboss.jca.common.api.metadata.ra.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra15.Activationspec15;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.common.v10.CommonConnDefImpl;
import org.jboss.jca.common.metadata.ironjacamar.v10.IronJacamarImpl;
import org.jboss.jca.common.metadata.ra.common.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.ra.common.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.ra.common.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageListenerImpl;
import org.jboss.jca.common.metadata.ra.common.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.ResourceAdapter1516Impl;
import org.jboss.jca.common.metadata.ra.ra15.Activationspec15Impl;
import org.jboss.jca.common.metadata.ra.ra15.Connector15Impl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public class PooledConnectionFactoryService
implements Service<Void> {
    private static final List<LocalizedXsdString> EMPTY_LOCL = Collections.emptyList();
    public static final String CONNECTOR_CLASSNAME = "connectorClassName";
    public static final String CONNECTION_PARAMETERS = "connectionParameters";
    private static final String HQ_ACTIVATION = "org.hornetq.ra.inflow.HornetQActivationSpec";
    private static final String HQ_CONN_DEF = "HornetQConnectionDefinition";
    private static final String HQ_ADAPTER = "org.hornetq.ra.HornetQResourceAdapter";
    private static final String RAMANAGED_CONN_FACTORY = "org.hornetq.ra.HornetQRAManagedConnectionFactory";
    private static final String RA_CONN_FACTORY = "org.hornetq.ra.HornetQRAConnectionFactory";
    private static final String RA_CONN_FACTORY_IMPL = "org.hornetq.ra.HornetQRAConnectionFactoryImpl";
    private static final String JMS_SESSION = "javax.jms.Session";
    private static final String HQ_SESSION = "org.hornetq.ra.HornetQRASession";
    private static final String BASIC_PASS = "BasicPassword";
    private static final String JMS_QUEUE = "javax.jms.Queue";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String LONG_TYPE = "java.lang.Long";
    private static final String SESSION_DEFAULT_TYPE = "SessionDefaultType";
    private static final String TRY_LOCK = "UseTryLock";
    private static final String JMS_MESSAGE_LISTENER = "javax.jms.MessageListener";
    private static final String DEFAULT_MAX_RECONNECTS = "5";
    public static final String GROUP_ADDRESS = "discoveryAddress";
    public static final String DISCOVERY_INITIAL_WAIT_TIMEOUT = "discoveryInitialWaitTimeout";
    public static final String GROUP_PORT = "discoveryPort";
    public static final String REFRESH_TIMEOUT = "discoveryRefreshTimeout";
    public static final String DISCOVERY_LOCAL_BIND_ADDRESS = "discoveryLocalBindAddress";
    public static final String TRANSACTION_MANAGER_LOCATOR_METHOD = "transactionManagerLocatorMethod";
    public static final String TRANSACTION_MANAGER_LOCATOR_CLASS = "transactionManagerLocatorClass";
    public static final String JGROUPS_CHANNEL_LOCATOR_CLASS = "jgroupsChannelLocatorClass";
    public static final String JGROUPS_CHANNEL_NAME = "jgroupsChannelName";
    public static final String JGROUPS_CHANNEL_REF_NAME = "jgroupsChannelRefName";
    private Injector<Object> transactionManager = new InjectedValue();
    private List<String> connectors;
    private String discoveryGroupName;
    private List<PooledConnectionFactoryConfigProperties> adapterParams;
    private String name;
    private Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>();
    private InjectedValue<HornetQServer> hornetQService = new InjectedValue();
    private ContextNames.BindInfo bindInfo;
    private List<String> jndiAliases;
    private String txSupport;
    private int minPoolSize;
    private int maxPoolSize;
    private String hqServerName;
    private final String jgroupsChannelName;
    private final boolean createBinderService;

    public PooledConnectionFactoryService(String name, List<String> connectors, String discoveryGroupName, String hqServerName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, List<String> jndiNames, String txSupport, int minPoolSize, int maxPoolSize) {
        this.name = name;
        this.connectors = connectors;
        this.discoveryGroupName = discoveryGroupName;
        this.hqServerName = hqServerName;
        this.jgroupsChannelName = jgroupsChannelName;
        this.adapterParams = adapterParams;
        this.initJNDIBindings(jndiNames);
        this.createBinderService = true;
        this.txSupport = txSupport;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    public PooledConnectionFactoryService(String name, List<String> connectors, String discoveryGroupName, String hqServerName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, String txSupport, int minPoolSize, int maxPoolSize) {
        this.name = name;
        this.connectors = connectors;
        this.discoveryGroupName = discoveryGroupName;
        this.hqServerName = hqServerName;
        this.jgroupsChannelName = jgroupsChannelName;
        this.adapterParams = adapterParams;
        this.bindInfo = bindInfo;
        this.jndiAliases = Collections.EMPTY_LIST;
        this.createBinderService = false;
        this.txSupport = txSupport;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    private void initJNDIBindings(List<String> jndiNames) {
        String jndiName = jndiNames.get(0);
        this.bindInfo = ContextNames.bindInfoFor((String)jndiName);
        this.jndiAliases = new ArrayList<String>();
        if (jndiNames.size() > 1) {
            this.jndiAliases = jndiNames.subList(1, jndiNames.size());
        }
    }

    public static void installService(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, ServiceTarget serviceTarget, String name, String hqServerName, List<String> connectors, String discoveryGroupName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, String txSupport, int minPoolSize, int maxPoolSize) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(hqServerName);
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        PooledConnectionFactoryService service = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, hqServerName, jgroupsChannelName, adapterParams, bindInfo, txSupport, minPoolSize, maxPoolSize);
        PooledConnectionFactoryService.installService0(verificationHandler, newControllers, serviceTarget, hqServiceName, serviceName, service);
    }

    public static void installService(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, ServiceTarget serviceTarget, String name, String hqServerName, List<String> connectors, String discoveryGroupName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, List<String> jndiNames, String txSupport, int minPoolSize, int maxPoolSize) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(hqServerName);
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        PooledConnectionFactoryService service = new PooledConnectionFactoryService(name, connectors, discoveryGroupName, hqServerName, jgroupsChannelName, adapterParams, jndiNames, txSupport, minPoolSize, maxPoolSize);
        PooledConnectionFactoryService.installService0(verificationHandler, newControllers, serviceTarget, hqServiceName, serviceName, service);
    }

    private static void installService0(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, ServiceTarget serviceTarget, ServiceName hqServiceName, ServiceName serviceName, PooledConnectionFactoryService service) {
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, service.transactionManager).addDependency(hqServiceName, HornetQServer.class, service.hornetQService).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName)).setInitialMode(ServiceController.Mode.PASSIVE);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget serviceTarget = context.getChildTarget();
        try {
            this.createService(serviceTarget, context.getController().getServiceContainer());
        }
        catch (Exception e) {
            throw MessagingMessages.MESSAGES.failedToCreate(e, "resource adapter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createService(ServiceTarget serviceTarget, ServiceContainer container) throws Exception {
        InputStream is = null;
        InputStream isIj = null;
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        try {
            StringBuilder connectorClassname = new StringBuilder();
            StringBuilder connectorParams = new StringBuilder();
            for (String connector : this.connectors) {
                TransportConfiguration tc = (TransportConfiguration)((HornetQServer)this.hornetQService.getValue()).getConfiguration().getConnectorConfigurations().get(connector);
                if (tc == null) {
                    throw MessagingMessages.MESSAGES.connectorNotDefined(connector);
                }
                if (connectorClassname.length() > 0) {
                    connectorClassname.append(",");
                    connectorParams.append(",");
                }
                connectorClassname.append(tc.getFactoryClassName());
                Map params = tc.getParams();
                boolean multiple = false;
                for (Map.Entry entry : params.entrySet()) {
                    if (multiple) {
                        connectorParams.append(";");
                    }
                    connectorParams.append((String)entry.getKey()).append("=").append(entry.getValue());
                    multiple = true;
                }
            }
            if (connectorClassname.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty15(CONNECTOR_CLASSNAME, STRING_TYPE, connectorClassname.toString()));
            }
            if (connectorParams.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty15(CONNECTION_PARAMETERS, STRING_TYPE, connectorParams.toString()));
            }
            if (this.discoveryGroupName != null) {
                DiscoveryGroupConfiguration discoveryGroupConfiguration = (DiscoveryGroupConfiguration)((HornetQServer)this.hornetQService.getValue()).getConfiguration().getDiscoveryGroupConfigurations().get(this.discoveryGroupName);
                BroadcastEndpointFactoryConfiguration bgCfg = discoveryGroupConfiguration.getBroadcastEndpointFactoryConfiguration();
                if (bgCfg instanceof UDPBroadcastGroupConfiguration) {
                    UDPBroadcastGroupConfiguration udpCfg = (UDPBroadcastGroupConfiguration)bgCfg;
                    properties.add(PooledConnectionFactoryService.simpleProperty15(GROUP_ADDRESS, STRING_TYPE, udpCfg.getGroupAddress()));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(GROUP_PORT, INTEGER_TYPE, "" + udpCfg.getGroupPort()));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(DISCOVERY_LOCAL_BIND_ADDRESS, STRING_TYPE, "" + udpCfg.getLocalBindAddress()));
                } else if (bgCfg instanceof JGroupsBroadcastGroupConfiguration) {
                    JGroupsChannelLocator.container = container;
                    properties.add(PooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_LOCATOR_CLASS, STRING_TYPE, JGroupsChannelLocator.class.getName()));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_NAME, STRING_TYPE, this.jgroupsChannelName));
                    properties.add(PooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_REF_NAME, STRING_TYPE, this.hqServerName + '/' + this.jgroupsChannelName));
                }
                properties.add(PooledConnectionFactoryService.simpleProperty15(DISCOVERY_INITIAL_WAIT_TIMEOUT, LONG_TYPE, "" + discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()));
                properties.add(PooledConnectionFactoryService.simpleProperty15(REFRESH_TIMEOUT, LONG_TYPE, "" + discoveryGroupConfiguration.getRefreshTimeout()));
            }
            boolean hasReconnect = false;
            String reconnectName = "reconnectAttempts";
            for (PooledConnectionFactoryConfigProperties adapterParam : this.adapterParams) {
                hasReconnect |= "reconnectAttempts".equals(adapterParam.getName());
                properties.add(PooledConnectionFactoryService.simpleProperty15(adapterParam.getName(), adapterParam.getType(), adapterParam.getValue()));
            }
            if (!hasReconnect) {
                properties.add(PooledConnectionFactoryService.simpleProperty15("reconnectAttempts", Integer.class.getName(), DEFAULT_MAX_RECONNECTS));
            }
            TransactionManagerLocator.container = container;
            AS7RecoveryRegistry.container = container;
            properties.add(PooledConnectionFactoryService.simpleProperty15(TRANSACTION_MANAGER_LOCATOR_CLASS, STRING_TYPE, TransactionManagerLocator.class.getName()));
            properties.add(PooledConnectionFactoryService.simpleProperty15(TRANSACTION_MANAGER_LOCATOR_METHOD, STRING_TYPE, "getTransactionManager"));
            OutboundResourceAdapter outbound = PooledConnectionFactoryService.createOutbound();
            InboundResourceAdapter inbound = this.createInbound();
            ResourceAdapter1516Impl ra = this.createResourceAdapter15(properties, outbound, inbound);
            Connector15Impl cmd = PooledConnectionFactoryService.createConnector15((ResourceAdapter1516)ra);
            TransactionSupportEnum transactionSupport = PooledConnectionFactoryService.getTransactionSupport(this.txSupport);
            CommonConnDef common = PooledConnectionFactoryService.createConnDef(transactionSupport, this.bindInfo.getBindName(), this.minPoolSize, this.maxPoolSize);
            IronJacamarImpl ijmd = PooledConnectionFactoryService.createIron(common, transactionSupport);
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService((Connector)cmd, (IronJacamar)ijmd, PooledConnectionFactoryService.class.getClassLoader(), this.name);
            activator.setBindInfo(this.bindInfo);
            activator.setCreateBinderService(this.createBinderService);
            ServiceController controller = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{this.name}), (Service)activator), (Injector)activator.getExecutorServiceInjector(), (boolean)false).addDependency(HornetQActivationService.getHornetQActivationServiceName(MessagingServices.getHornetQServiceName(this.hqServerName))).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, activator.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector()).addDependency(NamingService.SERVICE_NAME).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"})).setInitialMode(ServiceController.Mode.PASSIVE).install();
            this.createJNDIAliases(this.bindInfo, this.jndiAliases, (ServiceController<ResourceAdapterDeployment>)controller);
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{this.name}), Service.NULL).install();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isIj != null) {
                isIj.close();
            }
        }
    }

    private void createJNDIAliases(ContextNames.BindInfo bindInfo, List<String> aliases, ServiceController<ResourceAdapterDeployment> controller) {
        for (String alias : aliases) {
            if (controller.getServiceContainer().getService(ContextNames.bindInfoFor((String)alias).getBinderServiceName()) != null) continue;
            BinderServiceUtil.installAliasBinderService((ServiceTarget)controller.getServiceContainer(), bindInfo, alias);
        }
    }

    private static TransactionSupportEnum getTransactionSupport(String txSupport) {
        try {
            return TransactionSupportEnum.valueOf((String)txSupport);
        }
        catch (RuntimeException e) {
            return TransactionSupportEnum.LocalTransaction;
        }
    }

    private static IronJacamarImpl createIron(CommonConnDef common, TransactionSupportEnum transactionSupport) {
        List<CommonConnDef> definitions = Collections.singletonList(common);
        return new IronJacamarImpl(transactionSupport, Collections.emptyMap(), Collections.emptyList(), definitions, Collections.emptyList(), null);
    }

    private static CommonConnDef createConnDef(TransactionSupportEnum transactionSupport, String jndiName, int minPoolSize, int maxPoolSize) throws ValidateException {
        CommonPoolImpl pool;
        Integer minSize = minPoolSize == -1 ? null : Integer.valueOf(minPoolSize);
        Integer maxSize = maxPoolSize == -1 ? null : Integer.valueOf(maxPoolSize);
        boolean prefill = false;
        boolean useStrictMin = false;
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        Boolean isXA = Boolean.FALSE;
        if (transactionSupport == TransactionSupportEnum.XATransaction) {
            pool = new CommonXaPoolImpl(minSize, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
            isXA = Boolean.TRUE;
        } else {
            pool = new CommonPoolImpl(minSize, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        }
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(null, null, null, null, null);
        CommonSecurityImpl security = new CommonSecurityImpl(null, null, true);
        Recovery recovery = new Recovery((Credential)new CredentialImpl(null, null, null), null, Boolean.TRUE);
        CommonValidationImpl validation = new CommonValidationImpl(null, null, Boolean.valueOf(false));
        return new CommonConnDefImpl(Collections.emptyMap(), RAMANAGED_CONN_FACTORY, jndiName, HQ_CONN_DEF, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery, isXA);
    }

    private static Connector15Impl createConnector15(ResourceAdapter1516 ra) {
        return new Connector15Impl(PooledConnectionFactoryService.str("Red Hat"), PooledConnectionFactoryService.str("JMS 1.1 Server"), PooledConnectionFactoryService.str("1.0"), null, ra, EMPTY_LOCL, EMPTY_LOCL, Collections.emptyList(), null);
    }

    private ResourceAdapter1516Impl createResourceAdapter15(List<ConfigProperty> properties, OutboundResourceAdapter outbound, InboundResourceAdapter inbound) {
        return new ResourceAdapter1516Impl(HQ_ADAPTER, properties, outbound, inbound, Collections.emptyList(), Collections.emptyList(), null);
    }

    private InboundResourceAdapter createInbound() {
        List<RequiredConfigProperty> destination = Collections.singletonList(new RequiredConfigProperty(EMPTY_LOCL, PooledConnectionFactoryService.str("destination"), null));
        Activationspec15Impl activation15 = new Activationspec15Impl(PooledConnectionFactoryService.str(HQ_ACTIVATION), destination, null);
        List<MessageListenerImpl> messageListeners = Collections.singletonList(new MessageListenerImpl(PooledConnectionFactoryService.str(JMS_MESSAGE_LISTENER), (Activationspec15)activation15, null));
        MessageAdapterImpl message = new MessageAdapterImpl(messageListeners, null);
        return new InboundResourceAdapterImpl((Messageadapter)message, null);
    }

    private static OutboundResourceAdapter createOutbound() {
        ArrayList<ConnectionDefinitionImpl> definitions = new ArrayList<ConnectionDefinitionImpl>();
        ArrayList<ConfigProperty> props = new ArrayList<ConfigProperty>();
        props.add(PooledConnectionFactoryService.simpleProperty15(SESSION_DEFAULT_TYPE, STRING_TYPE, JMS_QUEUE));
        props.add(PooledConnectionFactoryService.simpleProperty15(TRY_LOCK, INTEGER_TYPE, "0"));
        definitions.add(new ConnectionDefinitionImpl(PooledConnectionFactoryService.str(RAMANAGED_CONN_FACTORY), props, PooledConnectionFactoryService.str(RA_CONN_FACTORY), PooledConnectionFactoryService.str(RA_CONN_FACTORY_IMPL), PooledConnectionFactoryService.str(JMS_SESSION), PooledConnectionFactoryService.str(HQ_SESSION), null));
        AuthenticationMechanismImpl basicPassword = new AuthenticationMechanismImpl(Collections.emptyList(), PooledConnectionFactoryService.str(BASIC_PASS), CredentialInterfaceEnum.PasswordCredential, null);
        return new OutboundResourceAdapterImpl(definitions, TransactionSupportEnum.XATransaction, Collections.singletonList(basicPassword), Boolean.valueOf(false), null);
    }

    private static XsdString str(String str) {
        return new XsdString(str, null);
    }

    private static ConfigProperty simpleProperty15(String name, String type, String value) {
        return new ConfigPropertyImpl(EMPTY_LOCL, PooledConnectionFactoryService.str(name), PooledConnectionFactoryService.str(type), PooledConnectionFactoryService.str(value), null);
    }

    public void stop(StopContext context) {
    }

    public Injector<Object> getTransactionManager() {
        return this.transactionManager;
    }

    Injector<SocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    public Injector<HornetQServer> getHornetQService() {
        return this.hornetQService;
    }
}

