/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class HornetQServerControlWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final HornetQServerControlWriteHandler INSTANCE = new HornetQServerControlWriteHandler();

    private HornetQServerControlWriteHandler() {
        super(CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry, boolean registerRuntimeOnly) {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            if (!registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (attr.getName().equals(CommonAttributes.CLUSTERED.getName())) {
                registry.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.CLUSTERED, ClusteredAttributeHandlers.READ_HANDLER, ClusteredAttributeHandlers.WRITE_HANDLER);
                continue;
            }
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
        registry.registerReadWriteAttribute(CommonAttributes.LIVE_CONNECTOR_REF, null, DeprecatedAttributeWriteHandler.INSTANCE);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName hqServiceName;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        if (!HornetQActivationService.isHornetQServerActive(context, operation)) {
            return false;
        }
        this.applyOperationToHornetQService(context, operation, attributeName, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry;
        ServiceController hqService;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (!attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES) && (hqService = (registry = context.getServiceRegistry(true)).getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))))) != null && hqService.getState() == ServiceController.State.UP) {
            ModelNode revertOp = operation.clone();
            revertOp.get(attributeName).set(valueToRestore);
            this.applyOperationToHornetQService(context, revertOp, attributeName, hqService);
        }
    }

    private void applyOperationToHornetQService(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> hqService) {
        block10: {
            HornetQServerControlImpl serverControl = ((HornetQServer)HornetQServer.class.cast(hqService.getValue())).getHornetQServerControl();
            if (serverControl == null) {
                ManagementUtil.rollbackOperationWithResourceNotFound(context, operation);
                return;
            }
            try {
                if (attributeName.equals(CommonAttributes.FAILOVER_ON_SHUTDOWN.getName())) {
                    serverControl.setFailoverOnServerShutdown(CommonAttributes.FAILOVER_ON_SHUTDOWN.resolveModelAttribute(context, operation).asBoolean());
                    break block10;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.getName())) {
                    serverControl.setMessageCounterSamplePeriod(CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.resolveModelAttribute(context, operation).asLong());
                    break block10;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.getName())) {
                    serverControl.setMessageCounterMaxDayCount(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.resolveModelAttribute(context, operation).asInt());
                    break block10;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName())) {
                    boolean enabled = CommonAttributes.MESSAGE_COUNTER_ENABLED.resolveModelAttribute(context, operation).asBoolean();
                    if (enabled) {
                        serverControl.enableMessageCounters();
                    } else {
                        serverControl.disableMessageCounters();
                    }
                    break block10;
                }
                throw MessagingMessages.MESSAGES.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ClusteredAttributeHandlers {
        static final OperationStepHandler READ_HANDLER = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean clustered = ClusteredAttributeHandlers.isClustered(context);
                context.getResult().set(clustered);
                context.stepCompleted();
            }
        };
        static final OperationStepHandler WRITE_HANDLER = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean clustered = ClusteredAttributeHandlers.isClustered(context);
                ModelNode mock = new ModelNode();
                mock.get(CommonAttributes.CLUSTERED.getName()).set(operation.get("value"));
                boolean wantsClustered = CommonAttributes.CLUSTERED.resolveModelAttribute(context, mock).asBoolean();
                if (clustered && !wantsClustered) {
                    PathAddress serverAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    MessagingLogger.MESSAGING_LOGGER.canNotChangeClusteredAttribute(serverAddress);
                }
                context.stepCompleted();
            }
        };

        private ClusteredAttributeHandlers() {
        }

        private static boolean isClustered(OperationContext context) {
            Set clusterConnectionNames = context.readResource(PathAddress.EMPTY_ADDRESS).getChildrenNames(ClusterConnectionDefinition.PATH.getKey());
            return !clusterConnectionNames.isEmpty();
        }
    }
}

