/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.ServletConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class ServletConnectorRemove
extends AbstractRemoveStepHandler {
    static final OperationStepHandler INSTANCE = new ServletConnectorRemove();

    private ServletConnectorRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (HornetQService.isHornetQServiceInstalled(context, operation)) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String hornetqServerName = address.getElement(address.size() - 1).getValue();
            String connectorName = address.getLastElement().getValue();
            ServiceName serviceName = ServletConnectorService.getServiceName(hornetqServerName, connectorName);
            context.removeService(serviceName);
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
        if (HornetQService.isHornetQServiceInstalled(context, operation)) {
            context.revertReloadRequired();
        }
    }
}

