/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class MigrateOperation
implements OperationStepHandler {
    private static final String MESSAGING_ACTIVEMQ_EXTENSION = "org.wildfly.extension.messaging-activemq";
    private static final String MESSAGING_ACTIVEMQ_MODULE = "org.wildfly.extension.messaging-activemq";
    private static final String NEW_ENTRY_SUFFIX = "-new";
    private static final OperationStepHandler DESCRIBE_MIGRATION_INSTANCE = new MigrateOperation(true);
    private static final OperationStepHandler MIGRATE_INSTANCE = new MigrateOperation(false);
    private static final AttributeDefinition ADD_LEGACY_ENTRIES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-legacy-entries", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).build();
    private final boolean describe;

    private MigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("migrate", resourceDescriptionResolver).setParameters(new AttributeDefinition[]{ADD_LEGACY_ENTRIES}).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), MIGRATE_INSTANCE);
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("describe-migration", resourceDescriptionResolver).addParameter(ADD_LEGACY_ENTRIES).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setRuntimeOnly().setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), DESCRIBE_MIGRATION_INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw MessagingLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        final boolean addLegacyEntries = ADD_LEGACY_ENTRIES.resolveModelAttribute(context, operation).asBoolean();
        final ModelNode legacyModelAddOps = new ModelNode();
        final LinkedHashMap<PathAddress, ModelNode> migrationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.describeLegacyMessagingResources(context, legacyModelAddOps);
        this.addMessagingActiveMQExtension(context, migrationOperations, this.describe);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                MigrateOperation.this.transformResources(legacyModelAddOps, migrationOperations, addLegacyEntries);
                MigrateOperation.this.removeMessagingSubsystem(migrationOperations);
                PathAddress parentAddress = context.getCurrentAddress().getParent();
                MigrateOperation.this.fixAddressesForDomainMode(parentAddress, migrationOperations);
                if (MigrateOperation.this.describe) {
                    context.getResult().set(migrationOperations.values());
                } else {
                    MigrateOperation.this.migrateSubsystems(context, migrationOperations);
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    private void fixAddressesForDomainMode(PathAddress parentAddress, Map<PathAddress, ModelNode> migrationOperations) {
        if (parentAddress.size() == 0) {
            return;
        }
        LinkedHashMap<PathAddress, ModelNode> fixedMigrationOperations = new LinkedHashMap<PathAddress, ModelNode>(migrationOperations);
        migrationOperations.clear();
        for (Map.Entry entry : fixedMigrationOperations.entrySet()) {
            PathAddress fixedAddress = parentAddress.append((PathAddress)entry.getKey());
            ((ModelNode)entry.getValue()).get("address").set(fixedAddress.toModelNode());
            migrationOperations.put(fixedAddress, (ModelNode)entry.getValue());
        }
    }

    private void addMessagingActiveMQExtension(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, boolean describe) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("extension").contains("org.wildfly.extension.messaging-activemq")) {
            return;
        }
        PathAddress extensionAddress = PathAddress.pathAddress((String)"extension", (String)"org.wildfly.extension.messaging-activemq");
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        addOperation.get("module").set("org.wildfly.extension.messaging-activemq");
        if (describe) {
            migrationOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void removeMessagingSubsystem(Map<PathAddress, ModelNode> migrationOperations) {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{MessagingExtension.SUBSYSTEM_PATH});
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)subsystemAddress);
        migrationOperations.put(subsystemAddress, removeOperation);
    }

    private void migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) {
        ModelNode compositeOp = Util.createOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        compositeOp.get("steps").set(migrationOperations.values());
        context.addStep(compositeOp, (OperationStepHandler)CompositeOperationHandler.INSTANCE, OperationContext.Stage.MODEL);
    }

    private ModelNode transformAddress(ModelNode legacyAddress) {
        ModelNode newAddress = new ModelNode();
        for (Property segment : legacyAddress.asPropertyList()) {
            Property newSegment;
            switch (segment.getName()) {
                case "subsystem": {
                    newSegment = new Property("subsystem", new ModelNode("messaging-activemq"));
                    break;
                }
                case "hornetq-server": {
                    newSegment = new Property("server", segment.getValue());
                    break;
                }
                default: {
                    newSegment = segment;
                }
            }
            newAddress.add(newSegment);
        }
        return newAddress;
    }

    private void transformResources(ModelNode legacyModelDescription, Map<PathAddress, ModelNode> newAddOperations, boolean addLegacyEntries) throws OperationFailedException {
        block23: for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            Property subsystemSubresource;
            ModelNode newAddOp = legacyAddOp.clone();
            ModelNode newAddress = this.transformAddress(legacyAddOp.get("address").clone());
            newAddOp.get("address").set(newAddress);
            if (newAddress.asList().size() > 2 && (subsystemSubresource = (Property)newAddress.asPropertyList().get(1)).getName().equals("server")) {
                Property serverSubresource = (Property)newAddress.asPropertyList().get(2);
                switch (serverSubresource.getName()) {
                    case "connection-factory": {
                        if (addLegacyEntries) {
                            PathAddress address = PathAddress.pathAddress((ModelNode)newAddress);
                            PathAddress legacyConnectionFactoryAddress = address.getParent().append("legacy-connection-factory", address.getLastElement().getValue());
                            ModelNode addLegacyConnectionFactoryOp = legacyAddOp.clone();
                            addLegacyConnectionFactoryOp.get("address").set(legacyConnectionFactoryAddress.toModelNode());
                            this.migrateConnectionFactory(addLegacyConnectionFactoryOp, "");
                            newAddOperations.put(PathAddress.pathAddress((ModelNode)addLegacyConnectionFactoryOp.get("address")), addLegacyConnectionFactoryOp);
                        }
                        this.migrateConnectionFactory(newAddOp, addLegacyEntries ? NEW_ENTRY_SUFFIX : "");
                        break;
                    }
                    case "pooled-connection-factory": {
                        this.migratePooledConnectionFactory(newAddOp);
                        break;
                    }
                    case "cluster-connection": {
                        this.migrateClusterConnection(newAddOp);
                        break;
                    }
                    case "bridge": {
                        this.migrateBridge(newAddOp);
                        break;
                    }
                    case "jms-queue": 
                    case "jms-topic": {
                        if (!addLegacyEntries) break;
                        this.addLegacyEntries(newAddOp);
                        break;
                    }
                    case "acceptor": 
                    case "http-acceptor": 
                    case "remote-acceptor": 
                    case "connector": 
                    case "http-connector": 
                    case "remote-connector": 
                    case "connector-service": {
                        if (newAddress.asPropertyList().size() <= 3) break;
                        String name = ((Property)newAddress.asPropertyList().get(3)).getValue().asString();
                        ModelNode value = newAddOp.get("value");
                        PathAddress currentAddress = PathAddress.pathAddress((ModelNode)newAddress);
                        ModelNode parentAddOp = newAddOperations.get(currentAddress.getParent());
                        parentAddOp.get("params").add(new Property(name, value));
                        continue block23;
                    }
                }
            }
            newAddOperations.put(PathAddress.pathAddress((ModelNode)newAddOp.get("address")), newAddOp);
        }
    }

    private void addLegacyEntries(ModelNode newAddOp) {
        newAddOp.get("legacy-entries").set(newAddOp.get("entries"));
        newAddOp.remove("entries");
        for (ModelNode legacyEntry : newAddOp.get("legacy-entries").asList()) {
            String newEntry = legacyEntry.asString() + NEW_ENTRY_SUFFIX;
            newAddOp.get("entries").add(newEntry);
        }
    }

    private void describeLegacyMessagingResources(OperationContext context, ModelNode legacyModelDescription) {
        ModelNode describeLegacySubsystem = Util.createOperation((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (PathAddress)context.getCurrentAddress());
        context.addStep(legacyModelDescription, describeLegacySubsystem, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }

    private void migrateConnectionFactory(ModelNode addOperation, String entrySuffix) {
        this.migrateConnectorAttribute(addOperation);
        this.migrateDiscoveryGroupNameAttribute(addOperation);
        if (!entrySuffix.isEmpty()) {
            List entries = addOperation.get("entries").asList();
            addOperation.remove("entries");
            for (ModelNode entry : entries) {
                String newEntry = entry.asString() + entrySuffix;
                addOperation.get("entries").add(newEntry);
            }
        }
    }

    private void migratePooledConnectionFactory(ModelNode addOperation) {
        this.migrateConnectorAttribute(addOperation);
        this.migrateDiscoveryGroupNameAttribute(addOperation);
    }

    private void migrateClusterConnection(ModelNode addOperation) {
        addOperation.get("connector-name").set(addOperation.get("connector-ref"));
        addOperation.remove("connector-ref");
    }

    private void migrateConnectorAttribute(ModelNode addOperation) {
        ModelNode connector = addOperation.get("connector");
        if (connector.isDefined()) {
            List connectorProps = connector.asPropertyList();
            for (Property connectorProp : connectorProps) {
                addOperation.get("connectors").add(connectorProp.getName());
            }
            addOperation.remove("connector");
        }
    }

    private void migrateDiscoveryGroupNameAttribute(ModelNode addOperation) {
        ModelNode discoveryGroup = addOperation.get("discovery-group-name");
        if (discoveryGroup.isDefined()) {
            addOperation.get("discovery-group").set(discoveryGroup);
            addOperation.remove("discovery-group-name");
        }
    }

    private void migrateBridge(ModelNode addOperation) {
        this.migrateDiscoveryGroupNameAttribute(addOperation);
    }
}

