/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GenericTransportDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPConnectorDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Messaging12SubsystemParser;
import org.jboss.as.messaging.Messaging13SubsystemParser;
import org.jboss.as.messaging.Messaging14SubsystemParser;
import org.jboss.as.messaging.Messaging20SubsystemParser;
import org.jboss.as.messaging.Messaging30SubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemRootResourceDefinition;
import org.jboss.as.messaging.MessagingTransformers;
import org.jboss.as.messaging.MessagingXMLWriter;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.PathDefinition;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.SecuritySettingDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"messaging");
    static final String RESOURCE_NAME = MessagingExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)3, (int)0, (int)0);
    public static final ModelVersion VERSION_2_1_0 = ModelVersion.create((int)2, (int)1, (int)0);
    public static final ModelVersion VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);
    public static final ModelVersion VERSION_1_3_0 = ModelVersion.create((int)1, (int)3, (int)0);
    public static final ModelVersion VERSION_1_2_1 = ModelVersion.create((int)1, (int)2, (int)1);
    public static final ModelVersion VERSION_1_2_0 = ModelVersion.create((int)1, (int)2, (int)0);
    public static final ModelVersion VERSION_1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);
    public static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)1, (int)4, (int)0);

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return MessagingExtension.getResourceDescriptionResolver(true, keyPrefix);
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, prefix.toString(), RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingXMLWriter.INSTANCE);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        ManagementResourceRegistration rootRegistration = subsystem.registerSubsystemModel((ResourceDefinition)MessagingSubsystemRootResourceDefinition.INSTANCE);
        rootRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration serverRegistration = rootRegistration.registerSubModel((ResourceDefinition)HornetQServerResourceDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)AddressSettingDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)BroadcastGroupDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)DiscoveryGroupDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)DivertDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)QueueDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)HTTPAcceptorDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.ACCEPTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.ACCEPTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.ACCEPTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)HTTPConnectorDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)GenericTransportDefinition.CONNECTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)RemoteTransportDefinition.CONNECTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)InVMTransportDefinition.CONNECTOR_INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)BridgeDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)ClusterConnectionDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)GroupingHandlerDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)ConnectorServiceDefinition.INSTANCE);
        for (String path : PathDefinition.PATHS.keySet()) {
            ManagementResourceRegistration binding = serverRegistration.registerSubModel((ResourceDefinition)new PathDefinition(PathElement.pathElement((String)"path", (String)path)));
            if (!context.getProcessType().isServer()) continue;
            ResolvePathHandler resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)PathDefinition.PATHS.get(path)).setRelativeToAttribute((AttributeDefinition)PathDefinition.RELATIVE_TO).build();
            binding.registerOperationHandler(resolvePathHandler.getOperationDefinition(), (OperationStepHandler)resolvePathHandler);
        }
        serverRegistration.registerSubModel((ResourceDefinition)ConnectionFactoryDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)PooledConnectionFactoryDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)JMSQueueDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)JMSTopicDefinition.INSTANCE);
        serverRegistration.registerSubModel((ResourceDefinition)SecuritySettingDefinition.INSTANCE);
        rootRegistration.registerSubModel((ResourceDefinition)JMSBridgeDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            MessagingTransformers.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_0.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_1.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_2.getUriString(), (XMLElementReader)Messaging12SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_3.getUriString(), (XMLElementReader)Messaging13SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_4.getUriString(), (XMLElementReader)Messaging14SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_1_5.getUriString(), (XMLElementReader)Messaging14SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_2_0.getUriString(), (XMLElementReader)Messaging20SubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MESSAGING_3_0.getUriString(), (XMLElementReader)Messaging30SubsystemParser.getInstance());
    }
}

