/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.List;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;

public class HAPolicyConfigurationBuilder {
    private static final HAPolicyConfigurationBuilder INSTANCE = new HAPolicyConfigurationBuilder();

    private HAPolicyConfigurationBuilder() {
    }

    public static HAPolicyConfigurationBuilder getInstance() {
        return INSTANCE;
    }

    public void addHAPolicyConfiguration(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        String type;
        if (!model.hasDefined("ha-policy")) {
            return;
        }
        Property prop = model.get("ha-policy").asProperty();
        ModelNode haPolicy = prop.getValue();
        configuration.setHAPolicyConfiguration(switch (type = prop.getName()) {
            case "live-only" -> this.buildLiveOnlyConfiguration(context, haPolicy);
            case "replication-master", "replication-primary" -> this.buildReplicationPrimaryConfiguration(context, haPolicy);
            case "replication-slave", "replication-secondary" -> this.buildReplicationSecondaryConfiguration(context, haPolicy);
            case "replication-colocated" -> this.buildReplicationColocatedConfiguration(context, haPolicy);
            case "shared-store-master", "shared-store-primary" -> this.buildSharedStorePrimaryConfiguration(context, haPolicy);
            case "shared-store-slave", "shared-store-secondary" -> this.buildSharedStoreSecondaryConfiguration(context, haPolicy);
            case "shared-store-colocated" -> this.buildSharedStoreColocatedConfiguration(context, haPolicy);
            default -> throw MessagingLogger.ROOT_LOGGER.unknownHAPolicyType();
        });
    }

    private HAPolicyConfiguration buildLiveOnlyConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ScaleDownConfiguration scaleDownConfiguration = ScaleDownAttributes.addScaleDownConfiguration(context, model);
        return new PrimaryOnlyPolicyConfiguration(scaleDownConfiguration);
    }

    private HAPolicyConfiguration buildReplicationPrimaryConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode groupName;
        ReplicatedPolicyConfiguration haPolicyConfiguration = new ReplicatedPolicyConfiguration();
        haPolicyConfiguration.setCheckForActiveServer(HAAttributes.CHECK_FOR_LIVE_SERVER.resolveModelAttribute(context, model).asBoolean()).setInitialReplicationSyncTimeout(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT.resolveModelAttribute(context, model).asLong());
        ModelNode clusterName = HAAttributes.CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            haPolicyConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = HAAttributes.GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            haPolicyConfiguration.setGroupName(groupName.asString());
        }
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildReplicationSecondaryConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode groupName;
        ReplicaPolicyConfiguration haPolicyConfiguration = new ReplicaPolicyConfiguration().setAllowFailBack(HAAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean()).setInitialReplicationSyncTimeout(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT.resolveModelAttribute(context, model).asLong()).setMaxSavedReplicatedJournalsSize(HAAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE.resolveModelAttribute(context, model).asInt()).setScaleDownConfiguration(ScaleDownAttributes.addScaleDownConfiguration(context, model)).setRestartBackup(HAAttributes.RESTART_BACKUP.resolveModelAttribute(context, model).asBoolean());
        ModelNode clusterName = HAAttributes.CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            haPolicyConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = HAAttributes.GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            haPolicyConfiguration.setGroupName(groupName.asString());
        }
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildReplicationColocatedConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        List connectors = HAAttributes.EXCLUDED_CONNECTORS.unwrap((ExpressionResolver)context, model);
        if (!connectors.isEmpty()) {
            haPolicyConfiguration.setExcludedConnectors(connectors);
        }
        ModelNode masterConfigurationModel = model.get(new String[]{"configuration", "primary"});
        HAPolicyConfiguration masterConfiguration = this.buildReplicationPrimaryConfiguration(context, masterConfigurationModel);
        haPolicyConfiguration.setPrimaryConfig(masterConfiguration);
        ModelNode slaveConfigurationModel = model.get(new String[]{"configuration", "secondary"});
        HAPolicyConfiguration slaveConfiguration = this.buildReplicationSecondaryConfiguration(context, slaveConfigurationModel);
        haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        return haPolicyConfiguration;
    }

    private HAPolicyConfiguration buildSharedStorePrimaryConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SharedStorePrimaryPolicyConfiguration().setFailoverOnServerShutdown(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN.resolveModelAttribute(context, model).asBoolean());
    }

    private HAPolicyConfiguration buildSharedStoreSecondaryConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        return new SharedStoreBackupPolicyConfiguration().setAllowFailBack(HAAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean()).setFailoverOnServerShutdown(HAAttributes.FAILOVER_ON_SERVER_SHUTDOWN.resolveModelAttribute(context, model).asBoolean()).setRestartBackup(HAAttributes.RESTART_BACKUP.resolveModelAttribute(context, model).asBoolean()).setScaleDownConfiguration(ScaleDownAttributes.addScaleDownConfiguration(context, model));
    }

    private HAPolicyConfiguration buildSharedStoreColocatedConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        ModelNode masterConfigurationModel = model.get(new String[]{"configuration", "primary"});
        HAPolicyConfiguration masterConfiguration = this.buildSharedStorePrimaryConfiguration(context, masterConfigurationModel);
        haPolicyConfiguration.setPrimaryConfig(masterConfiguration);
        ModelNode slaveConfigurationModel = model.get(new String[]{"configuration", "secondary"});
        HAPolicyConfiguration slaveConfiguration = this.buildSharedStoreSecondaryConfiguration(context, slaveConfigurationModel);
        haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        return haPolicyConfiguration;
    }
}

