/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.FileHandlerResourceDefinition;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.LoggingRootResource;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.LoggingSubsystemWriter;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.stdio.LogContextStdioContextSelector;
import org.jboss.logmanager.ClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.ThreadLocalLogContextSelector;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public class LoggingExtension
implements Extension {
    private static final String RESOURCE_NAME = LoggingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String SUBSYSTEM_NAME = "logging";
    static final PathElement LOGGING_PROFILE_PATH = PathElement.pathElement((String)"logging-profile");
    static final ClassLoaderLogContextSelector CONTEXT_SELECTOR = new ClassLoaderLogContextSelector();
    static final ThreadLocalLogContextSelector THREAD_LOCAL_CONTEXT_SELECTOR = new ThreadLocalLogContextSelector((LogContextSelector)CONTEXT_SELECTOR);
    static final GenericSubsystemDescribeHandler DESCRIBE_HANDLER = GenericSubsystemDescribeHandler.create((Comparator)LoggingChildResourceComparator.INSTANCE);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModuleIdentifier[] LOGGING_API_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"org.apache.commons.logging"), ModuleIdentifier.create((String)"org.apache.log4j"), ModuleIdentifier.create((String)"org.jboss.logging"), ModuleIdentifier.create((String)"org.jboss.logging.jul-to-slf4j-stub"), ModuleIdentifier.create((String)"org.jboss.logmanager"), ModuleIdentifier.create((String)"org.slf4j"), ModuleIdentifier.create((String)"org.slf4j.ext"), ModuleIdentifier.create((String)"org.slf4j.impl")};

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new LoggingResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, LoggingExtension.class.getClassLoader());
    }

    public void initialize(ExtensionContext context) {
        if (!java.util.logging.LogManager.getLogManager().getClass().getName().equals(LogManager.class.getName())) {
            throw LoggingMessages.MESSAGES.extensionNotInitialized();
        }
        LogContext.setLogContextSelector((LogContextSelector)THREAD_LOCAL_CONTEXT_SELECTOR);
        StdioContext.setStdioContextSelector((StdioContextSelector)new LogContextStdioContextSelector(StdioContext.getStdioContext()));
        try {
            ModuleLoader moduleLoader = Module.forClass(LoggingExtension.class).getModuleLoader();
            for (ModuleIdentifier moduleIdentifier : LOGGING_API_MODULES) {
                try {
                    CONTEXT_SELECTOR.addLogApiClassLoader((ClassLoader)moduleLoader.loadModule(moduleIdentifier).getClassLoader());
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)LoggingRootResource.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)DESCRIBE_HANDLER);
        ResolvePathHandler resolvePathHandler = context.getProcessType().isServer() ? ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setParentAttribute((AttributeDefinition)CommonAttributes.FILE).build() : null;
        this.registerSubModels(registration, resolvePathHandler, true);
        ApplicationTypeConfig atc = new ApplicationTypeConfig(SUBSYSTEM_NAME, "logging-profile");
        final List accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
        SimpleResourceDefinition profile = new SimpleResourceDefinition(LOGGING_PROFILE_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0]), LoggingProfileOperations.ADD_PROFILE, LoggingProfileOperations.REMOVE_PROFILE){

            public List<AccessConstraintDefinition> getAccessConstraints() {
                return accessConstraints;
            }
        };
        this.registerSubModels(registration.registerSubModel((ResourceDefinition)profile), resolvePathHandler, false);
        if (context.isRegisterTransformers()) {
            this.registerTransformers1_1_0(subsystem);
            this.registerTransformers1_2_0(subsystem);
            this.registerTransformers1_3_0(subsystem);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemWriter.INSTANCE);
    }

    private void registerTransformers1_1_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder subsystemBuilder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        subsystemBuilder.rejectChildResource(LOGGING_PROFILE_PATH);
        ResourceTransformationDescriptionBuilder loggingProfileBuilder = TransformationDescriptionBuilder.Factory.createInstance((PathElement)LOGGING_PROFILE_PATH);
        RootLoggerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        LoggerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        AsyncHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        ConsoleHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        FileHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        PeriodicHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        SizeRotatingHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        CustomHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        SyslogHandlerResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        PatternFormatterResourceDefinition.addTransformers(subsystemBuilder, loggingProfileBuilder);
        TransformationDescription.Tools.register((TransformationDescription)subsystemBuilder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0));
    }

    private void registerTransformers1_2_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder subsystemBuilder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        SizeRotatingHandlerResourceDefinition.addTransformers_1_2(subsystemBuilder);
        TransformationDescription.Tools.register((TransformationDescription)subsystemBuilder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    private void registerTransformers1_3_0(SubsystemRegistration subsystem) {
        TransformationDescription.Tools.register((TransformationDescription)LoggingExtension.get1_2_0_1_3_0Description(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)3, (int)0));
    }

    private static TransformationDescription get1_2_0_1_3_0Description() {
        ResourceTransformationDescriptionBuilder subsystemBuilder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        return subsystemBuilder.build();
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.readable()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
        }
    }

    private void registerSubModels(ManagementResourceRegistration registration, ResolvePathHandler resolvePathHandler, boolean includeLegacyAttributes) {
        registration.registerSubModel((ResourceDefinition)new RootLoggerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new LoggerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new AsyncHandlerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new ConsoleHandlerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new FileHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new PeriodicHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new SizeRotatingHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new CustomHandlerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)SyslogHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)PatternFormatterResourceDefinition.INSTANCE);
    }

    public static class LoggingChildResourceComparator
    implements Comparator<PathElement> {
        static final LoggingChildResourceComparator INSTANCE = new LoggingChildResourceComparator();
        static final int GREATER = 1;
        static final int EQUAL = 0;
        static final int LESS = -1;

        @Override
        public int compare(PathElement o1, PathElement o2) {
            String key2;
            String key1 = o1.getKey();
            int result = key1.compareTo(key2 = o2.getKey());
            if (result != 0) {
                if ("subsystem".equals(key1)) {
                    result = -1;
                } else if ("subsystem".equals(key2)) {
                    result = 1;
                } else if ("logging-profile".equals(key1)) {
                    result = -1;
                } else if ("logging-profile".equals(key2)) {
                    result = 1;
                } else if ("root-logger".equals(key1)) {
                    result = 1;
                } else if ("root-logger".equals(key2)) {
                    result = -1;
                } else if ("logger".equals(key1)) {
                    result = 1;
                } else if ("logger".equals(key2)) {
                    result = -1;
                } else if ("async-handler".equals(key1)) {
                    result = 1;
                } else if ("async-handler".equals(key2)) {
                    result = -1;
                }
            }
            return result;
        }
    }

    private static class LoggingResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private static final Map<String, String> COMMON_ATTRIBUTE_NAMES = new HashMap<String, String>();

        public LoggingResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
            super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName.split("\\.")[0])) {
                return bundle2.getString(this.getBundleKey(attributeName));
            }
            return super.getResourceAttributeDescription(attributeName, locale, bundle2);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
            }
            return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getBundleKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
            }
            return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
        }

        public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                if (this.isReuseAttributesForAdd()) {
                    return bundle2.getString(this.getVariableBundleKey(paramName, "deprecated"));
                }
                return bundle2.getString(this.getVariableBundleKey(operationName, paramName, "deprecated"));
            }
            return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle2);
        }

        public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle2.getString(this.getVariableBundleKey(attributeName, "deprecated"));
            }
            return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle2);
        }

        private String getBundleKey(String name) {
            return this.getVariableBundleKey(name, new String[0]);
        }

        private String getVariableBundleKey(String name, String ... variable) {
            String prefix = COMMON_ATTRIBUTE_NAMES.get(name.split("\\.")[0]);
            StringBuilder sb = prefix == null ? new StringBuilder(name) : new StringBuilder(prefix).append('.').append(name);
            if (variable != null) {
                for (String arg : variable) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(arg);
                }
            }
            return sb.toString();
        }

        static {
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.APPEND.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.AUTOFLUSH.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CustomHandlerResourceDefinition.CLASS.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENABLED.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENCODING.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILE.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER_SPEC.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(AbstractHandlerDefinition.FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.HANDLERS.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.LEVEL.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CustomHandlerResourceDefinition.MODULE.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.NAME.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(AbstractHandlerDefinition.NAMED_FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.OVERFLOW_ACTION.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.PATH.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CustomHandlerResourceDefinition.PROPERTIES.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.QUEUE_LENGTH.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.RELATIVE_TO.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(AsyncHandlerResourceDefinition.SUBHANDLERS.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PeriodicHandlerResourceDefinition.SUFFIX.getName(), "logging.periodic-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(ConsoleHandlerResourceDefinition.TARGET.getName(), "logging.console-handler");
        }
    }
}

