/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.Logging;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class CustomHandlerResourceDefinition
extends AbstractHandlerDefinition {
    public static final String CUSTOM_HANDLER = "custom-handler";
    static final PathElement CUSTOM_HANDLE_PATH = PathElement.pathElement((String)"custom-handler");
    public static final SimpleAttributeDefinition CLASS = SimpleAttributeDefinitionBuilder.create((String)"class", (ModelType)ModelType.STRING).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition MODULE = SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setAllowExpression(false).build();
    public static final SimpleMapAttributeDefinition PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("properties", true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if ((resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                writer.writeStartElement(attribute.getName());
                for (ModelNode property : resourceModel.asList()) {
                    writer.writeEmptyElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute("name", property.asProperty().getName());
                    writer.writeAttribute("value", property.asProperty().getValue().asString());
                }
                writer.writeEndElement();
            }
        }
    })).build();
    static final AttributeDefinition[] READ_ONLY_ATTRIBUTES = new AttributeDefinition[]{CLASS, MODULE};
    static final AttributeDefinition[] WRITABLE_ATTRIBUTES = Logging.join(DEFAULT_ATTRIBUTES, NAMED_FORMATTER, PROPERTIES);
    static final AttributeDefinition[] ADD_ATTRIBUTES = Logging.join(WRITABLE_ATTRIBUTES, READ_ONLY_ATTRIBUTES);

    public CustomHandlerResourceDefinition(boolean includeLegacyAttributes) {
        super(CUSTOM_HANDLE_PATH, null, includeLegacyAttributes ? Logging.join(ADD_ATTRIBUTES, LEGACY_ATTRIBUTES) : ADD_ATTRIBUTES, READ_ONLY_ATTRIBUTES, includeLegacyAttributes ? Logging.join(WRITABLE_ATTRIBUTES, LEGACY_ATTRIBUTES) : WRITABLE_ATTRIBUTES, new ConfigurationProperty[0]);
    }

    static ResourceTransformationDescriptionBuilder addTransformers(ResourceTransformationDescriptionBuilder subsystemBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        ResourceTransformationDescriptionBuilder child = ((AttributeTransformationDescriptionBuilder)subsystemBuilder.addChildResource(CUSTOM_HANDLE_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{PROPERTIES})).end();
        loggingProfileBuilder.rejectChildResource(CUSTOM_HANDLE_PATH);
        return CustomHandlerResourceDefinition.registerTransformers(child);
    }
}

