/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.PropertyConfigurable;

public class PropertyObjectTypeAttributeDefinition
extends ObjectTypeAttributeDefinition
implements ConfigurationProperty<String> {
    private final ModelNodeResolver<String> resolver;
    private final String propertyName;

    private PropertyObjectTypeAttributeDefinition(String name, String xmlName, String propertyName, String suffix, AttributeDefinition[] valueTypes, boolean allowNull, ModelNodeResolver<String> resolver, ParameterValidator validator, ParameterCorrector corrector, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        super(name, xmlName, suffix, valueTypes, allowNull, validator, corrector, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, accessConstraints, flags);
        this.propertyName = propertyName;
        this.resolver = resolver;
    }

    @Override
    public ModelNodeResolver<String> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        String result = null;
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver == null ? value.asString() : this.resolver.resolveValue(context, value);
        }
        return result;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        String value = this.resolvePropertyValue(context, model);
        if (value == null) {
            configuration.removeProperty(this.propertyName);
        } else {
            configuration.setPropertyValueString(this.propertyName, value);
        }
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, PropertyObjectTypeAttributeDefinition> {
        private ModelNodeResolver<String> resolver;
        private String propertyName;
        private String suffix;
        private final AttributeDefinition[] valueTypes;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            super(name, ModelType.OBJECT, true);
            this.valueTypes = valueTypes;
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public PropertyObjectTypeAttributeDefinition build() {
            ParameterValidator validator;
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if ((validator = this.validator) == null) {
                validator = new ObjectTypeValidator(this.allowNull, this.valueTypes);
            }
            return new PropertyObjectTypeAttributeDefinition(this.name, this.xmlName, this.propertyName, this.suffix, this.valueTypes, this.allowNull, (ModelNodeResolver)this.resolver, validator, this.corrector, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.accessConstraints, this.flags);
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder setResolver(ModelNodeResolver<String> resolver) {
            this.resolver = resolver;
            return this;
        }
    }
}

