/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.LinkedList;
import java.util.Properties;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jacorb.IORSettingsDefinition;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.iiop.openjdk.AttributeConstants;
import org.wildfly.iiop.openjdk.IIOPSubsystemAdd;

public class JacORBSubsystemAdd
extends IIOPSubsystemAdd {
    static final JacORBSubsystemAdd INSTANCE = new JacORBSubsystemAdd();

    private JacORBSubsystemAdd() {
        super(JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.printJacORBEmulationWarningMessage();
        super.performRuntime(context, operation, model);
    }

    private void printJacORBEmulationWarningMessage() {
        JacORBLogger.ROOT_LOGGER.jacorbEmulationWarning();
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        if (!context.getProcessType().equals((Object)ProcessType.HOST_CONTROLLER)) {
            LinkedList<String> propertiesToReject = new LinkedList<String>();
            for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT) {
                if (!model.hasDefined(attributeDefinition.getName()) || !model.get(attributeDefinition.getName()).equals(JacORBSubsystemDefinitions.DEFAULT_ENABLED_PROPERTY)) continue;
                propertiesToReject.add(attributeDefinition.getName());
            }
            for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT) {
                if (!model.hasDefined(attributeDefinition.getName())) continue;
                propertiesToReject.add(attributeDefinition.getName());
            }
            if (!propertiesToReject.isEmpty()) {
                throw JacORBLogger.ROOT_LOGGER.cannotEmulateProperties(propertiesToReject);
            }
        }
    }

    protected Properties getConfigurationProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Object value;
        String name;
        Properties props = new Properties();
        for (AttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES) {
            ModelNode resolvedModelAttribute;
            if (JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT.contains(attrDefinition) || JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT.contains(attrDefinition) || !(resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model)).isDefined()) continue;
            name = attrDefinition.getName();
            value = resolvedModelAttribute.asString();
            this.transformAndSetProperty(props, name, (String)value);
        }
        if (model.hasDefined("properties")) {
            ModelNode propertiesNode = model.get("properties");
            for (Property property : propertiesNode.asPropertyList()) {
                name = property.getName();
                value = property.getValue();
                props.setProperty(name, value.asString());
            }
        }
        return props;
    }

    private void transformAndSetProperty(Properties props, String name, String value) {
        switch (name) {
            case "persistent-server-id": {
                props.setProperty("org.omg.CORBA.ORBServerId", value);
                break;
            }
            case "giop-minor-version": {
                props.setProperty("com.sun.CORBA.giop.ORBGIOPVersion", "1." + value);
                break;
            }
            case "transactions": {
                if (value.equals("on")) {
                    props.setProperty(name, "full");
                    break;
                }
                if (value.equals("off")) {
                    props.setProperty(name, "none");
                    break;
                }
                props.setProperty(name, value);
                break;
            }
            case "support-ssl": {
                if (value.equals("on")) {
                    props.setProperty(name, AttributeConstants.TrueFalse.TRUE.toString());
                    break;
                }
                props.setProperty(name, AttributeConstants.TrueFalse.FALSE.toString());
                break;
            }
            case "add-component-via-interceptor": {
                if (value.equals("on")) {
                    props.setProperty(name, AttributeConstants.TrueFalse.TRUE.toString());
                    break;
                }
                props.setProperty(name, AttributeConstants.TrueFalse.FALSE.toString());
                break;
            }
            case "export-corbaloc": {
                if (value.equals("on")) {
                    props.setProperty(name, AttributeConstants.TrueFalse.TRUE.toString());
                    break;
                }
                props.setProperty(name, AttributeConstants.TrueFalse.FALSE.toString());
                break;
            }
            default: {
                props.setProperty(name, value);
            }
        }
    }

    protected PathElement getIORSettingsPath() {
        return IORSettingsDefinition.INSTANCE.getPathElement();
    }
}

