/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.AbstractServerGroupRolloutTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;

class ConcurrentServerGroupUpdateTask
extends AbstractServerGroupRolloutTask
implements Runnable {
    public ConcurrentServerGroupUpdateTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject) {
        super(tasks, updatePolicy, executor, subject);
    }

    @Override
    public void execute() {
        ServerIdentity identity;
        HashSet<ServerIdentity> outstanding = new HashSet<ServerIdentity>();
        ServerTaskExecutor.ServerOperationListener listener = new ServerTaskExecutor.ServerOperationListener();
        for (ServerUpdateTask task : this.tasks) {
            identity = task.getServerIdentity();
            if (this.updatePolicy.canUpdateServer(identity)) {
                if (!this.executor.executeTask((TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation>)listener, task)) continue;
                outstanding.add(task.getServerIdentity());
                continue;
            }
            DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.tracef("Skipping server update task for %s", identity);
        }
        boolean interrupted = false;
        while (!outstanding.isEmpty()) {
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                identity = ((ServerTaskExecutor.ServerOperation)prepared.getOperation()).getIdentity();
                this.recordPreparedOperation(identity, (TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation>)prepared);
                outstanding.remove(identity);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

