/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.ApplyMissingDomainModelResourcesHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationCoordinatorStepHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;

public class PrepareStepHandler
implements OperationStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final OperationCoordinatorStepHandler coordinatorHandler;
    private final OperationSlaveStepHandler slaveHandler;

    public PrepareStepHandler(LocalHostControllerInfo localHostControllerInfo, ContentRepository contentRepository, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ExtensionRegistry extensionRegistry, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.slaveHandler = new OperationSlaveStepHandler(localHostControllerInfo, serverProxies, ignoredDomainResourceRegistry, extensionRegistry);
        this.coordinatorHandler = new OperationCoordinatorStepHandler(localHostControllerInfo, contentRepository, hostProxies, serverProxies, this.slaveHandler, runtimeIgnoreTransformationRegistry);
    }

    public void initialize(ApplyMissingDomainModelResourcesHandler applyMissingDomainModelResourcesHandler) {
        this.slaveHandler.intialize(applyMissingDomainModelResourcesHandler);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isBooting()) {
            this.executeDirect(context, operation);
        } else if (operation.hasDefined("operation-headers") && operation.get("operation-headers").hasDefined("execute-for-coordinator") && operation.get("operation-headers").get("execute-for-coordinator").asBoolean()) {
            this.slaveHandler.execute(context, operation);
        } else {
            if (!operation.hasDefined("operation-headers") || !operation.get("operation-headers").hasDefined("domain-uuid")) {
                operation.get(new String[]{"operation-headers", "domain-uuid"}).set(UUID.randomUUID().toString());
            }
            if (this.isServerOperation(operation)) {
                this.executeDirect(context, operation);
            } else {
                this.coordinatorHandler.execute(context, operation);
            }
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.coordinatorHandler.setExecutorService(executorService);
    }

    private boolean isServerOperation(ModelNode operation) {
        PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return addr.size() > 1 && "host".equals(addr.getElement(0).getKey()) && this.localHostControllerInfo.getLocalHostName().equals(addr.getElement(0).getValue()) && "server".equals(addr.getElement(1).getKey());
    }

    private void executeDirect(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s executing direct", this.getClass().getSimpleName());
        }
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = null;
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            stepHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        }
        if (stepHandler != null) {
            context.addStep(stepHandler, OperationContext.Stage.MODEL);
        } else {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (registration == null) {
                context.getFailureDescription().set(ControllerMessages.MESSAGES.noSuchResourceType(pathAddress));
            } else {
                context.getFailureDescription().set(ControllerMessages.MESSAGES.noHandlerForOperation(operationName, pathAddress));
            }
        }
        context.stepCompleted();
    }
}

