/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.concurrent.CountDownLatch;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

public class HostControllerBootstrap {
    private final ShutdownHook shutdownHook;
    private final ServiceContainer serviceContainer;
    private final HostControllerEnvironment environment;
    private final byte[] authCode;

    public HostControllerBootstrap(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
        this.shutdownHook = new ShutdownHook();
        this.serviceContainer = this.shutdownHook.register();
    }

    public void bootstrap() throws Exception {
        HostRunningModeControl runningModeControl = this.environment.getRunningModeControl();
        ControlledProcessState processState = new ControlledProcessState(true);
        this.shutdownHook.setControlledProcessState(processState);
        ServiceTarget target = this.serviceContainer.subTarget();
        ControlledProcessStateService.addService((ServiceTarget)target, (ControlledProcessState)processState);
        HostControllerService hcs = new HostControllerService(this.environment, runningModeControl, this.authCode, processState);
        target.addService(HostControllerService.HC_SERVICE_NAME, (Service)hcs).install();
    }

    private static class ShutdownHook
    extends Thread {
        private boolean down;
        private ControlledProcessState processState;
        private ServiceContainer container;

        private ShutdownHook() {
        }

        private ServiceContainer register() {
            Runtime.getRuntime().addShutdownHook(this);
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                if (!this.down) {
                    this.container = ServiceContainer.Factory.create((String)"host-controller", (boolean)false);
                    return this.container;
                }
                throw new IllegalStateException();
            }
        }

        private synchronized void setControlledProcessState(ControlledProcessState ps) {
            this.processState = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                CountDownLatch latch;
                ControlledProcessState ps;
                ServiceContainer sc;
                ShutdownHook shutdownHook = this;
                synchronized (shutdownHook) {
                    this.down = true;
                    sc = this.container;
                    ps = this.processState;
                }
                try {
                    if (ps != null) {
                        ps.setStopping();
                    }
                    if (sc == null) break block13;
                    latch = new CountDownLatch(1);
                }
                catch (Throwable throwable) {
                    if (sc != null) {
                        CountDownLatch latch2 = new CountDownLatch(1);
                        sc.addTerminateListener(new ServiceContainer.TerminateListener(latch2){
                            final /* synthetic */ CountDownLatch val$latch;
                            {
                                this.val$latch = countDownLatch;
                            }

                            public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                                this.val$latch.countDown();
                            }
                        });
                        sc.shutdown();
                        while (true) {
                            try {
                                latch2.await();
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    throw throwable;
                }
                sc.addTerminateListener(new /* invalid duplicate definition of identical inner class */);
                sc.shutdown();
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

