/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.security;

import jakarta.security.jacc.PolicyConfiguration;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.security.JaccService;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbSecurityDeployer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class JaccEjbDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String ELYTRON_JACC_CAPABILITY = "org.wildfly.security.jacc-policy";
    public static final String ELYTRON_JAKARTA_AUTHORIZATION = "org.wildfly.security.jakarta-authorization";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        boolean requireJakartaAuthorization;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaccEjbDeploymentProcessor.deploymentContainsEjbs(deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        boolean usesElytronJaccPolicy = capabilitySupport.hasCapability(ELYTRON_JACC_CAPABILITY);
        boolean bl = requireJakartaAuthorization = usesElytronJaccPolicy || capabilitySupport.hasCapability(ELYTRON_JAKARTA_AUTHORIZATION);
        if (!requireJakartaAuthorization) {
            return;
        }
        EjbSecurityDeployer deployer = null;
        deployer = new EjbSecurityDeployer();
        JaccService service = deployer.deploy(deploymentUnit);
        if (service != null) {
            DeploymentUnit parentDU = deploymentUnit.getParent();
            ServiceName jaccServiceName = this.getJaccServiceName(deploymentUnit);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(jaccServiceName, (Service)service);
            if (parentDU != null) {
                builder.addDependency(parentDU.getServiceName().append(JaccService.SERVICE_NAME), PolicyConfiguration.class, service.getParentPolicyInjector());
            }
            if (usesElytronJaccPolicy) {
                builder.requires(capabilitySupport.getCapabilityServiceName(ELYTRON_JACC_CAPABILITY));
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    private static boolean deploymentContainsEjbs(DeploymentUnit deploymentUnit) {
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        for (ComponentConfiguration current : moduleConfiguration.getComponentConfigurations()) {
            if (!(current.getComponentDescription() instanceof EJBComponentDescription)) continue;
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        ServiceController serviceController;
        EjbSecurityDeployer deployer = new EjbSecurityDeployer();
        deployer.undeploy(deploymentUnit);
        ServiceName jaccServiceName = this.getJaccServiceName(deploymentUnit);
        ServiceRegistry registry = deploymentUnit.getServiceRegistry();
        if (registry != null && (serviceController = registry.getService(jaccServiceName)) != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private ServiceName getJaccServiceName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        ServiceName jaccServiceName = deploymentUnit.getServiceName().append(JaccService.SERVICE_NAME).append(new String[]{"ejb"});
        if (parentDU != null) {
            jaccServiceName = jaccServiceName.append(new String[]{parentDU.getName()});
        }
        return jaccServiceName;
    }
}

