/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentClientInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class StatefulComponentSessionIdGeneratingInterceptor
implements Interceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new StatefulComponentSessionIdGeneratingInterceptor());

    private StatefulComponentSessionIdGeneratingInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof StatefulSessionComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, StatefulSessionComponent.class);
        }
        ComponentClientInstance clientInstance = (ComponentClientInstance)context.getPrivateData(ComponentClientInstance.class);
        SessionID existing = (SessionID)context.getPrivateData(SessionID.class);
        if (existing != null) {
            clientInstance.setViewInstanceData(SessionID.class, (Object)existing);
        } else {
            StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
            statefulComponent.waitForComponentStart();
            clientInstance.setViewInstanceData(SessionID.class, (Object)statefulComponent.createSession());
        }
        return context.proceed();
    }
}

