/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.FilterSpecClassResolverFilter;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ProtocolSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.clustering.ejb.remote.ClientMappingsRegistryProvider;
import org.wildfly.clustering.ejb.remote.LegacyClientMappingsRegistryProviderFactory;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.common.net.Inet;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class EJB3RemoteServiceAdd
extends AbstractBoottimeAddStepHandler {
    private static final LegacyClientMappingsRegistryProviderFactory LEGACY_PROVIDER_FACTORY = ServiceLoader.load(LegacyClientMappingsRegistryProviderFactory.class, LegacyClientMappingsRegistryProviderFactory.class.getClassLoader()).findFirst().orElse(null);
    private static final UnaryServiceDescriptor<List<ClientMapping>> CLIENT_MAPPINGS = UnaryServiceDescriptor.of((String)"org.wildfly.ejb.remote.client-mappings", List.class);

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (operation.hasDefined(EJB3RemoteResourceDefinition.CONNECTOR_REF.getName())) {
            ModelNode connectorRef = operation.remove(EJB3RemoteResourceDefinition.CONNECTOR_REF.getName());
            operation.get(EJB3RemoteResourceDefinition.CONNECTORS.getName()).set(new ModelNode().add(connectorRef));
        }
        super.populateModel(context, operation, resource);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.installRuntimeServices(context, model);
    }

    void installRuntimeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        List connectorNameNodes = EJB3RemoteResourceDefinition.CONNECTORS.resolveModelAttribute(context, model).asList();
        String threadPoolName = EJB3RemoteResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asString();
        boolean executeInWorker = EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.resolveModelAttribute(context, model).asBoolean();
        for (ModelNode connectorNameNode : connectorNameNodes) {
            final String connectorName = connectorNameNode.asString();
            ServiceDependency remotingConnectorInfo = ServiceDependency.on((String)"org.wildfly.remoting.connector", ProtocolSocketBinding.class, (String[])new String[]{connectorName});
            ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(EJB3RemoteServiceAdd::getClientMappings, (Supplier)remotingConnectorInfo).provides(ServiceNameFactory.resolveServiceName(CLIENT_MAPPINGS, (String)connectorName))).requires((Consumer)remotingConnectorInfo)).build()).install(context);
            final ServiceDependency<ClientMappingsRegistryProvider> provider = EJB3RemoteServiceAdd.getClientMappingsRegistryProvider(context, model);
            final CapabilityServiceSupport support = context.getCapabilityServiceSupport();
            ServiceInstaller installer = new ServiceInstaller(){

                public ServiceController<?> install(RequirementServiceTarget target) {
                    for (ServiceInstaller installer : ((ClientMappingsRegistryProvider)provider.get()).getServiceInstallers(support, connectorName, ServiceDependency.on(CLIENT_MAPPINGS, (String)connectorName))) {
                        ServiceController controller = installer.install((ServiceTarget)target);
                        ServiceName registryParentName = ServiceNameFactory.parseServiceName((String)ClusteringServiceDescriptor.REGISTRY.getName());
                        for (ServiceName providedName : controller.provides()) {
                            if (!registryParentName.isParentOf(providedName)) continue;
                            ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)ServiceDependency.on((ServiceName)providedName)).provides(ServiceNameFactory.resolveServiceName(EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_REGISTRY, (String)connectorName))).build()).install((ServiceTarget)target);
                        }
                    }
                    return null;
                }
            };
            ((ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)installer, (CapabilityServiceSupport)context.getCapabilityServiceSupport()).requires(provider)).build()).install(context);
        }
        OptionMap channelCreationOptions = this.getChannelCreationOptions(context);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(EJB3RemoteResourceDefinition.EJB_REMOTE_CAPABILITY);
        Consumer serviceConsumer = builder.provides(EJB3RemoteResourceDefinition.EJB_REMOTE_CAPABILITY);
        Supplier endpointSupplier = builder.requiresCapability("org.wildfly.remoting.endpoint", Endpoint.class, new String[0]);
        Supplier executorSupplier = !executeInWorker ? builder.requires(EJB3SubsystemRootResourceDefinition.EXECUTOR_SERVICE_DESCRIPTOR, threadPoolName) : Functions.constantSupplier(null);
        Supplier associationServiceSupplier = builder.requires(AssociationService.SERVICE_NAME);
        Supplier remotingTransactionServiceSupplier = builder.requiresCapability("org.wildfly.transactions.remote-transaction-service", RemotingTransactionService.class, new String[0]);
        builder.addAliases(new ServiceName[]{EJBRemoteConnectorService.SERVICE_NAME}).setInitialMode(ServiceController.Mode.LAZY);
        EJBRemoteConnectorService ejbRemoteConnectorService = new EJBRemoteConnectorService(serviceConsumer, endpointSupplier, executorSupplier, associationServiceSupplier, remotingTransactionServiceSupplier, channelCreationOptions, FilterSpecClassResolverFilter.getFilterForOperationContext(context));
        builder.setInstance((Service)ejbRemoteConnectorService);
        builder.install();
    }

    private OptionMap getChannelCreationOptions(OperationContext context) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode channelCreationOptions = fullModel.get("channel-creation-options");
        if (channelCreationOptions.isDefined() && channelCreationOptions.asInt() > 0) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            OptionMap.Builder builder = OptionMap.builder();
            for (Property optionProperty : channelCreationOptions.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = EJB3RemoteServiceAdd.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                builder.set(option, option.parseValue(value, loader));
            }
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private static String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }

    private static ServiceDependency<ClientMappingsRegistryProvider> getClientMappingsRegistryProvider(OperationContext context, ModelNode model) throws OperationFailedException {
        if (context.hasOptionalCapability(ClientMappingsRegistryProvider.SERVICE_DESCRIPTOR, EJB3RemoteResourceDefinition.EJB_REMOTE_CAPABILITY, null)) {
            return ServiceDependency.on((NullaryServiceDescriptor)ClientMappingsRegistryProvider.SERVICE_DESCRIPTOR);
        }
        String clusterName = EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.resolveModelAttribute(context, model).asString();
        context.requireOptionalCapability(RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)clusterName), "org.wildfly.ejb.remote", EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.getName());
        EjbLogger.ROOT_LOGGER.legacyClientMappingsRegistryProviderInUse(clusterName);
        return ServiceDependency.of((Object)LEGACY_PROVIDER_FACTORY.createClientMappingsRegistryProvider(clusterName));
    }

    static List<ClientMapping> getClientMappings(ProtocolSocketBinding info) {
        InetAddress clientNetworkAddress;
        List clientMappings = info.getSocketBinding().getClientMappings();
        if (!clientMappings.isEmpty()) {
            return clientMappings;
        }
        InetAddress destination = info.getSocketBinding().getAddress();
        String destinationName = Inet.toURLString((InetAddress)destination, (boolean)true);
        try {
            clientNetworkAddress = destination instanceof Inet4Address ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName("::");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return List.of(new ClientMapping(clientNetworkAddress, 0, destinationName, info.getSocketBinding().getAbsolutePort()));
    }
}

