/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DefaultComponentConfigurator;
import org.jboss.as.ee.component.DefaultComponentViewConfigurator;
import org.jboss.as.ee.component.DefaultInterceptorConfigurator;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class ComponentDescription
implements ResourceInjectionTarget {
    private static final DefaultComponentConfigurator DEFAULT_COMPONENT_CONFIGURATOR = new DefaultComponentConfigurator();
    private static final DefaultInterceptorConfigurator DEFAULT_INTERCEPTOR_CONFIGURATOR = new DefaultInterceptorConfigurator();
    private static final DefaultComponentViewConfigurator DEFAULT_COMPONENT_VIEW_CONFIGURATOR = new DefaultComponentViewConfigurator();
    private final ServiceName serviceName;
    private ServiceName contextServiceName;
    private final String componentName;
    private final String componentClassName;
    private final EEModuleDescription moduleDescription;
    private final Set<ViewDescription> views = new HashSet<ViewDescription>();
    private final Map<String, InterceptorClassDescription> interceptorClassOverrides = new HashMap<String, InterceptorClassDescription>();
    private List<InterceptorDescription> classInterceptors = new ArrayList<InterceptorDescription>();
    private List<InterceptorDescription> defaultInterceptors = new ArrayList<InterceptorDescription>();
    private final Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private final Set<MethodIdentifier> methodExcludeDefaultInterceptors = new HashSet<MethodIdentifier>();
    private final Set<MethodIdentifier> methodExcludeClassInterceptors = new HashSet<MethodIdentifier>();
    private Set<InterceptorDescription> allInterceptors;
    private boolean excludeDefaultInterceptors = false;
    private boolean ignoreLifecycleInterceptors = false;
    private final Map<ServiceName, ServiceBuilder.DependencyType> dependencies = new HashMap<ServiceName, ServiceBuilder.DependencyType>();
    private ComponentNamingMode namingMode = ComponentNamingMode.USE_MODULE;
    private DeploymentDescriptorEnvironment deploymentDescriptorEnvironment;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Map<String, Map<InjectionTarget, ResourceInjectionConfiguration>> resourceInjections = new HashMap<String, Map<InjectionTarget, ResourceInjectionConfiguration>>();
    private final Deque<ComponentConfigurator> configurators = new ArrayDeque<ComponentConfigurator>();
    private String beanDeploymentArchiveId;

    public ComponentDescription(String componentName, String componentClassName, EEModuleDescription moduleDescription, ServiceName deploymentUnitServiceName) {
        this.moduleDescription = moduleDescription;
        if (componentName == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("name");
        }
        if (componentClassName == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("componentClassName");
        }
        if (moduleDescription == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("moduleDescription");
        }
        if (deploymentUnitServiceName == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("deploymentUnitServiceName");
        }
        this.serviceName = BasicComponent.serviceNameOf(deploymentUnitServiceName, componentName);
        this.componentName = componentName;
        this.componentClassName = componentClassName;
        this.configurators.addLast(DEFAULT_COMPONENT_CONFIGURATOR);
        this.configurators.addLast(DEFAULT_INTERCEPTOR_CONFIGURATOR);
        this.configurators.addLast(DEFAULT_COMPONENT_VIEW_CONFIGURATOR);
    }

    public ComponentConfiguration createConfiguration(ClassIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        return new ComponentConfiguration(this, classIndex, moduleClassLoader, moduleLoader);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setContextServiceName(ServiceName contextServiceName) {
        this.contextServiceName = contextServiceName;
    }

    public ServiceName getContextServiceName() {
        if (this.contextServiceName != null) {
            return this.contextServiceName;
        }
        if (this.getNamingMode() == ComponentNamingMode.CREATE) {
            return ContextNames.contextServiceNameOfComponent((String)this.getApplicationName(), (String)this.getModuleName(), (String)this.getComponentName());
        }
        if (this.getNamingMode() == ComponentNamingMode.USE_MODULE) {
            return ContextNames.contextServiceNameOfModule((String)this.getApplicationName(), (String)this.getModuleName());
        }
        throw new IllegalStateException();
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ServiceName getStartServiceName() {
        return this.serviceName.append(new String[]{"START"});
    }

    public ServiceName getCreateServiceName() {
        return this.serviceName.append(new String[]{"CREATE"});
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getModuleName() {
        return this.moduleDescription.getModuleName();
    }

    public String getApplicationName() {
        return this.moduleDescription.getApplicationName();
    }

    public List<InterceptorDescription> getClassInterceptors() {
        return this.classInterceptors;
    }

    public void setClassInterceptors(List<InterceptorDescription> classInterceptors) {
        this.classInterceptors = classInterceptors;
        this.allInterceptors = null;
    }

    public List<InterceptorDescription> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(List<InterceptorDescription> defaultInterceptors) {
        this.allInterceptors = null;
        this.defaultInterceptors = defaultInterceptors;
    }

    public Set<InterceptorDescription> getAllInterceptors() {
        if (this.allInterceptors == null) {
            this.allInterceptors = new HashSet<InterceptorDescription>();
            this.allInterceptors.addAll(this.classInterceptors);
            if (!this.excludeDefaultInterceptors) {
                this.allInterceptors.addAll(this.defaultInterceptors);
            }
            for (List<InterceptorDescription> interceptors : this.methodInterceptors.values()) {
                this.allInterceptors.addAll(interceptors);
            }
        }
        return this.allInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.allInterceptors = null;
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public boolean isIgnoreLifecycleInterceptors() {
        return this.ignoreLifecycleInterceptors;
    }

    public void setIgnoreLifecycleInterceptors(boolean ignoreLifecycleInterceptors) {
        this.ignoreLifecycleInterceptors = ignoreLifecycleInterceptors;
    }

    public void excludeDefaultInterceptors(MethodIdentifier method) {
        this.methodExcludeDefaultInterceptors.add(method);
    }

    public boolean isExcludeDefaultInterceptors(MethodIdentifier method) {
        return this.methodExcludeDefaultInterceptors.contains(method);
    }

    public void excludeClassInterceptors(MethodIdentifier method) {
        this.methodExcludeClassInterceptors.add(method);
    }

    public boolean isExcludeClassInterceptors(MethodIdentifier method) {
        return this.methodExcludeClassInterceptors.contains(method);
    }

    public void addClassInterceptor(InterceptorDescription description) {
        this.classInterceptors.add(description);
        this.allInterceptors = null;
    }

    public InterceptorDescription getClassInterceptor(String interceptorClassName) {
        for (InterceptorDescription interceptor : this.classInterceptors) {
            if (!interceptor.getInterceptorClassName().equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public void addMethodInterceptor(MethodIdentifier method, InterceptorDescription description) {
        List<InterceptorDescription> interceptors = this.methodInterceptors.get(method);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorDescription>();
            this.methodInterceptors.put(method, interceptors);
        }
        String name = description.getInterceptorClassName();
        interceptors.add(description);
        this.allInterceptors = null;
    }

    public void setMethodInterceptors(MethodIdentifier identifier, List<InterceptorDescription> interceptorDescriptions) {
        this.methodInterceptors.put(identifier, interceptorDescriptions);
        this.methodExcludeClassInterceptors.add(identifier);
        this.methodExcludeDefaultInterceptors.add(identifier);
    }

    public void addInterceptorMethodOverride(String className, InterceptorClassDescription override) {
        this.interceptorClassOverrides.put(className, InterceptorClassDescription.merge(this.interceptorClassOverrides.get(className), override));
    }

    public ComponentNamingMode getNamingMode() {
        return this.namingMode;
    }

    public void setNamingMode(ComponentNamingMode namingMode) {
        if (namingMode == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("namingMode");
        }
        this.namingMode = namingMode;
    }

    public EEModuleDescription getModuleDescription() {
        return this.moduleDescription;
    }

    public void addDependency(ServiceName serviceName, ServiceBuilder.DependencyType type) {
        if (serviceName == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("serviceName");
        }
        if (type == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("type");
        }
        Map<ServiceName, ServiceBuilder.DependencyType> dependencies = this.dependencies;
        ServiceBuilder.DependencyType dependencyType = dependencies.get(serviceName);
        if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
            dependencies.put(serviceName, ServiceBuilder.DependencyType.REQUIRED);
        } else {
            dependencies.put(serviceName, type);
        }
    }

    public Map<ServiceName, ServiceBuilder.DependencyType> getDependencies() {
        return this.dependencies;
    }

    public DeploymentDescriptorEnvironment getDeploymentDescriptorEnvironment() {
        return this.deploymentDescriptorEnvironment;
    }

    public void setDeploymentDescriptorEnvironment(DeploymentDescriptorEnvironment deploymentDescriptorEnvironment) {
        this.deploymentDescriptorEnvironment = deploymentDescriptorEnvironment;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Set<ViewDescription> getViews() {
        return this.views;
    }

    public boolean isTimerServiceApplicable() {
        return false;
    }

    public boolean isTimerServiceRequired() {
        return this.isTimerServiceApplicable() && !this.getTimerMethods().isEmpty();
    }

    public Set<MethodIdentifier> getTimerMethods() {
        return Collections.emptySet();
    }

    public boolean isPassivationApplicable() {
        return false;
    }

    public Deque<ComponentConfigurator> getConfigurators() {
        return this.configurators;
    }

    public boolean isIntercepted() {
        return true;
    }

    public boolean isOptional() {
        return false;
    }

    public String getBeanDeploymentArchiveId() {
        return this.beanDeploymentArchiveId;
    }

    public void setBeanDeploymentArchiveId(String beanDeploymentArchiveId) {
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
    }

    @Override
    public void addResourceInjection(ResourceInjectionConfiguration injection) {
        String className = injection.getTarget().getClassName();
        Map<InjectionTarget, ResourceInjectionConfiguration> map = this.resourceInjections.get(className);
        if (map == null) {
            map = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();
            this.resourceInjections.put(className, map);
        }
        map.put(injection.getTarget(), injection);
    }

    public Map<InjectionTarget, ResourceInjectionConfiguration> getResourceInjections(String className) {
        Map<InjectionTarget, ResourceInjectionConfiguration> injections = this.resourceInjections.get(className);
        if (injections == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(injections);
    }

    public boolean isCDIInterceptorEnabled() {
        return false;
    }

    public static InterceptorClassDescription mergeInterceptorConfig(Class<?> clazz, EEModuleClassDescription classDescription, ComponentDescription description, boolean metadataComplete) {
        InterceptorClassDescription interceptorConfig = classDescription != null && !metadataComplete ? InterceptorClassDescription.merge(classDescription.getInterceptorClassDescription(), description.interceptorClassOverrides.get(clazz.getName())) : InterceptorClassDescription.merge(null, description.interceptorClassOverrides.get(clazz.getName()));
        return interceptorConfig;
    }

    static class InjectedConfigurator
    implements DependencyConfigurator<ComponentStartService> {
        private final ResourceInjectionConfiguration injectionConfiguration;
        private final ComponentConfiguration configuration;
        private final DeploymentPhaseContext context;
        private final InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue;

        InjectedConfigurator(ResourceInjectionConfiguration injectionConfiguration, ComponentConfiguration configuration, DeploymentPhaseContext context, InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue) {
            this.injectionConfiguration = injectionConfiguration;
            this.configuration = configuration;
            this.context = context;
            this.managedReferenceFactoryValue = managedReferenceFactoryValue;
        }

        @Override
        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
            InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(this.configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, this.configuration.getComponentName(), this.configuration.getModuleName(), this.configuration.getApplicationName());
            this.injectionConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, this.context, (Injector<ManagedReferenceFactory>)this.managedReferenceFactoryValue);
        }
    }
}

