/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.resource.definition;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.property.PropertyReplacer;

public abstract class ResourceDefinitionInjectionSource
extends InjectionSource {
    protected final String jndiName;
    protected final Map<String, String> properties = new HashMap<String, String>();

    public ResourceDefinitionInjectionSource(String jndiName) {
        this.jndiName = jndiName.startsWith("java:") ? jndiName : "java:comp/env/" + jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    protected String uniqueName(InjectionSource.ResolutionContext context) {
        StringBuilder name = new StringBuilder();
        name.append(context.getApplicationName() + "_");
        name.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            name.append(context.getComponentName() + "_");
        }
        name.append(this.jndiName);
        return name.toString();
    }

    public void addProperties(String[] annotationProperties) {
        this.addProperties(annotationProperties, null);
    }

    public void addProperties(String[] annotationProperties, PropertyReplacer propertyReplacer) {
        if (annotationProperties != null) {
            for (String annotationProperty : annotationProperties) {
                String propertyValue;
                String propertyName;
                int index;
                if (propertyReplacer != null) {
                    annotationProperty = propertyReplacer.replaceProperties(annotationProperty);
                }
                if ((index = annotationProperty.indexOf(61)) != -1) {
                    propertyName = annotationProperty.substring(0, index);
                    propertyValue = annotationProperty.length() > index ? annotationProperty.substring(index + 1) : "";
                } else {
                    propertyName = annotationProperty;
                    propertyValue = "";
                }
                this.properties.put(propertyName, propertyValue);
            }
        }
    }

    public void addProperties(PropertiesMetaData descriptorProperties) {
        if (descriptorProperties != null) {
            for (PropertyMetaData descriptorProperty : descriptorProperties) {
                this.properties.put(descriptorProperty.getName(), descriptorProperty.getValue());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDefinitionInjectionSource that = (ResourceDefinitionInjectionSource)o;
        if (!this.jndiName.equals(that.jndiName)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.jndiName.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

