/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.InterceptorEnvironment;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.utils.InjectionUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.modules.Module;

public abstract class AbstractDeploymentDescriptorBindingsProcessor
implements DeploymentUnitProcessor {
    private static final Map<Class<?>, Class<?>> BOXED_TYPES;

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List<BindingConfiguration> bindings;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (module == null || description == null) {
            return;
        }
        if (environment != null) {
            List<BindingConfiguration> bindings2 = this.processDescriptorEntries(deploymentUnit, environment, description, null, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex, applicationClasses);
            description.getBindingConfigurations().addAll(bindings2);
        }
        for (ComponentDescription componentDescription : description.getComponentDescriptions()) {
            if (componentDescription.getDeploymentDescriptorEnvironment() == null) continue;
            bindings = this.processDescriptorEntries(deploymentUnit, componentDescription.getDeploymentDescriptorEnvironment(), componentDescription, componentDescription, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex, applicationClasses);
            componentDescription.getBindingConfigurations().addAll(bindings);
        }
        for (InterceptorEnvironment interceptorEnv : description.getInterceptorEnvironment().values()) {
            bindings = this.processDescriptorEntries(deploymentUnit, interceptorEnv.getDeploymentDescriptorEnvironment(), interceptorEnv, null, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex, applicationClasses);
            interceptorEnv.getBindingConfigurations().addAll(bindings);
        }
    }

    protected abstract List<BindingConfiguration> processDescriptorEntries(DeploymentUnit var1, DeploymentDescriptorEnvironment var2, ResourceInjectionTarget var3, ComponentDescription var4, ClassLoader var5, DeploymentReflectionIndex var6, EEApplicationClasses var7) throws DeploymentUnitProcessingException;

    protected Class<?> processInjectionTargets(ResourceInjectionTarget resourceInjectionTarget, InjectionSource injectionSource, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, ResourceInjectionMetaData entry, Class<?> classType) throws DeploymentUnitProcessingException {
        if (entry.getInjectionTargets() != null) {
            for (ResourceInjectionTargetMetaData injectionTarget : entry.getInjectionTargets()) {
                String memberName;
                String injectionTargetName;
                String injectionTargetClassName = injectionTarget.getInjectionTargetClass();
                AccessibleObject fieldOrMethod = InjectionUtils.getInjectionTarget(injectionTargetClassName, injectionTargetName = injectionTarget.getInjectionTargetName(), classLoader, deploymentReflectionIndex);
                Class<?> injectionTargetType = fieldOrMethod instanceof Field ? ((Field)fieldOrMethod).getType() : ((Method)fieldOrMethod).getParameterTypes()[0];
                String string = memberName = fieldOrMethod instanceof Field ? ((Field)fieldOrMethod).getName() : ((Method)fieldOrMethod).getName();
                if (classType != null) {
                    if (!injectionTargetType.isAssignableFrom(classType)) {
                        boolean ok = false;
                        if (classType.isPrimitive()) {
                            if (BOXED_TYPES.get(classType).equals(injectionTargetType)) {
                                ok = true;
                            }
                        } else if (injectionTargetType.isPrimitive() && BOXED_TYPES.get(injectionTargetType).equals(classType)) {
                            ok = true;
                        }
                        if (!ok) {
                            throw EeLogger.ROOT_LOGGER.invalidInjectionTarget(injectionTarget.getInjectionTargetName(), injectionTarget.getInjectionTargetClass(), classType);
                        }
                        classType = injectionTargetType;
                    }
                } else {
                    classType = injectionTargetType;
                }
                InjectionTarget injectionTargetDescription = fieldOrMethod instanceof Field ? new FieldInjectionTarget(injectionTargetClassName, memberName, classType.getName()) : new MethodInjectionTarget(injectionTargetClassName, memberName, classType.getName());
                ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration(injectionTargetDescription, injectionSource);
                resourceInjectionTarget.addResourceInjection(injectionConfiguration);
            }
        }
        return classType;
    }

    static {
        HashMap<Class<Serializable>, Class> types = new HashMap<Class<Serializable>, Class>();
        types.put(Integer.TYPE, Integer.class);
        types.put(Byte.TYPE, Byte.class);
        types.put(Short.TYPE, Short.class);
        types.put(Long.TYPE, Long.class);
        types.put(Character.TYPE, Character.class);
        types.put(Float.TYPE, Float.class);
        types.put(Double.TYPE, Double.class);
        types.put(Boolean.TYPE, Boolean.class);
        BOXED_TYPES = Collections.unmodifiableMap(types);
    }
}

