/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.GlobalDirectoryResourceDefinition;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ExternalModule;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class GlobalDirectoryDeploymentService
implements Service {
    private List<Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory>> globalDirectories;
    private final ExternalModule externalModuleService;
    private final ModuleSpecification moduleSpecification;
    private final ModuleLoader moduleLoader;
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;

    public GlobalDirectoryDeploymentService(List<Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory>> globalDirectories, ExternalModule externalModuleService, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
        this.globalDirectories = globalDirectories;
        this.moduleSpecification = moduleSpecification;
        this.externalModuleService = externalModuleService;
        this.moduleLoader = moduleLoader;
        this.serviceRegistry = serviceRegistry;
        this.serviceTarget = serviceTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ArrayList<GlobalDirectoryResourceDefinition.GlobalDirectory> dataSorted = new ArrayList<GlobalDirectoryResourceDefinition.GlobalDirectory>();
        for (Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory> dataSupplier : this.globalDirectories) {
            GlobalDirectoryResourceDefinition.GlobalDirectory data = dataSupplier.get();
            dataSorted.add(data);
        }
        for (GlobalDirectoryResourceDefinition.GlobalDirectory globalDirectory : dataSorted) {
            if (Files.exists(globalDirectory.getResolvedPath(), new LinkOption[0])) continue;
            throw EeLogger.ROOT_LOGGER.globalDirectoryDoNotExist(globalDirectory.getResolvedPath().toString(), globalDirectory.getName());
        }
        Collections.sort(dataSorted, Comparator.comparing(GlobalDirectoryResourceDefinition.GlobalDirectory::getModuleName));
        Iterator<Supplier<GlobalDirectoryResourceDefinition.GlobalDirectory>> iterator = this.externalModuleService;
        synchronized (iterator) {
            for (GlobalDirectoryResourceDefinition.GlobalDirectory data : dataSorted) {
                Path resolvedPath = data.getResolvedPath();
                String moduleName = data.getModuleName();
                String moduleIdentifier = this.externalModuleService.addExternalModule(moduleName, resolvedPath.toString(), this.serviceRegistry, this.serviceTarget).toString();
                this.moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)this.moduleLoader, (String)moduleIdentifier).setImportServices(true).build());
            }
        }
    }

    public void stop(StopContext context) {
    }
}

