/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

final class FileKeystore {
    private KeyStore keyStore;
    private final String path;
    private long lastModificationTime;
    private final char[] keystorePassword;
    private final boolean isKeyStore;
    private final char[] keyPassword;
    private final String alias;

    private FileKeystore(String path, char[] keystorePassword) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = null;
        this.alias = null;
        this.lastModificationTime = 0L;
        this.isKeyStore = false;
    }

    private FileKeystore(String path, char[] keystorePassword, char[] keyPassword, String alias) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.alias = alias;
        this.lastModificationTime = 0L;
        this.isKeyStore = true;
    }

    static FileKeystore newKeyStore(String path, char[] keystorePassword, char[] keyPassword, String alias) {
        return new FileKeystore(path, keystorePassword, keyPassword, alias);
    }

    static FileKeystore newTrustStore(String path, char[] keystorePassword) {
        return new FileKeystore(path, keystorePassword);
    }

    boolean isModified() {
        long lastModified = new File(this.path).lastModified();
        if (lastModified > this.lastModificationTime) {
            return true;
        }
        return lastModified == 0L;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void load() throws StartException {
        FileInputStream fis = null;
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            if (new File(this.path).exists()) {
                fis = new FileInputStream(this.path);
                loadedKeystore.load(fis, this.keystorePassword);
            } else {
                if (this.isKeyStore) {
                    throw DomainManagementMessages.MESSAGES.keyStoreNotFound(this.path);
                }
                loadedKeystore.load(null);
            }
            if (this.isKeyStore) {
                this.assertContainsKey(loadedKeystore);
            }
            if (this.alias == null) {
                this.setKeyStore(loadedKeystore);
            } else {
                KeyStore newKeystore = KeyStore.getInstance("JKS");
                newKeystore.load(null);
                KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(this.keyPassword == null ? this.keystorePassword : this.keyPassword);
                if (!loadedKeystore.containsAlias(this.alias)) throw DomainManagementMessages.MESSAGES.aliasNotFound(this.alias, this.validAliasList(loadedKeystore));
                if (!loadedKeystore.isKeyEntry(this.alias)) throw DomainManagementMessages.MESSAGES.aliasNotKey(this.alias, this.validAliasList(loadedKeystore));
                KeyStore.Entry entry = loadedKeystore.getEntry(this.alias, passParam);
                newKeystore.setEntry(this.alias, entry, passParam);
                this.setKeyStore(newKeystore);
            }
            this.lastModificationTime = new File(this.path).lastModified();
            this.safeClose(fis);
            return;
        }
        catch (KeyStoreException e) {
            try {
                throw DomainManagementMessages.MESSAGES.unableToStart(e);
                catch (NoSuchAlgorithmException e2) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e2);
                }
                catch (CertificateException e3) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e3);
                }
                catch (IOException e4) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e4);
                }
                catch (UnrecoverableEntryException e5) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e5);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(fis);
                throw throwable;
            }
        }
    }

    private void assertContainsKey(KeyStore keyStore) throws StartException, KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            if (!keyStore.isKeyEntry(aliases.nextElement())) continue;
            return;
        }
        throw DomainManagementMessages.MESSAGES.noKey(this.path);
    }

    private String validAliasList(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        StringBuilder sb = new StringBuilder("{");
        while (aliases.hasMoreElements()) {
            String current = aliases.nextElement();
            if (!keyStore.isKeyEntry(current)) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(current);
        }
        return sb.append("}").toString();
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    private void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    private void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final class ServiceUtil {
        private static final String KEYSTORE_SUFFIX = "keystore";
        private static final String TRUSTSTORE_SUFFIX = "truststore";

        private ServiceUtil() {
        }

        public static ServiceName createKeystoreServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{KEYSTORE_SUFFIX});
        }

        public static ServiceName createTrusttoreServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{TRUSTSTORE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<FileKeystore> injector, ServiceName serviceName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, serviceName, FileKeystore.class, injector);
            return sb;
        }
    }
}

