/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.ThreadLocalSSLSocketFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LdapConnectionManagerService
implements Service<LdapConnectionManagerService>,
ConnectionManager {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private final InjectedValue<SSLIdentity> sslIdentity = new InjectedValue();
    private volatile ModelNode resolvedConfiguration;

    public LdapConnectionManagerService(ModelNode resolvedConfiguration) {
        this.setResolvedConfiguration(resolvedConfiguration);
    }

    void setResolvedConfiguration(ModelNode resolvedConfiguration) {
        resolvedConfiguration.require(LdapConnectionResourceDefinition.URL.getName());
        resolvedConfiguration.require(LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.getName());
        this.resolvedConfiguration = resolvedConfiguration;
    }

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SSLIdentity> getSSLIdentityInjector() {
        return this.sslIdentity;
    }

    @Override
    public Object getConnection() throws Exception {
        ModelNode config = this.resolvedConfiguration;
        return this.getConnection(this.getFullProperties(config), this.getSSLContext(false));
    }

    @Override
    public Object getConnection(String principal, String credential) throws Exception {
        ModelNode config = this.resolvedConfiguration;
        Properties connectionProperties = this.getConnectionOnlyProperties(config);
        connectionProperties.put("java.naming.security.principal", principal);
        connectionProperties.put("java.naming.security.credentials", credential);
        return this.getConnection(connectionProperties, this.getSSLContext(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConnection(Properties properties, SSLContext sslContext) throws Exception {
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.setSSLSocketFactory(sslContext.getSocketFactory());
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(ThreadLocalSSLSocketFactory.class);
                properties.put("java.naming.ldap.factory.socket", ThreadLocalSSLSocketFactory.class.getName());
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.removeSSLSocketFactory();
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
        }
    }

    private SSLContext getSSLContext(boolean trustOnly) {
        SSLIdentity sslIdentityValue = (SSLIdentity)this.sslIdentity.getOptionalValue();
        if (sslIdentityValue != null) {
            return trustOnly ? sslIdentityValue.getTrustOnlyContext() : sslIdentityValue.getFullContext();
        }
        return null;
    }

    private Properties getConnectionOnlyProperties(ModelNode config) {
        Properties result = new Properties();
        String initialContextFactory = config.require("initial-context-factory").asString();
        result.put("java.naming.factory.initial", initialContextFactory);
        String url = config.require("url").asString();
        result.put("java.naming.provider.url", url);
        return result;
    }

    private Properties getFullProperties(ModelNode config) {
        Properties result = this.getConnectionOnlyProperties(config);
        if (config.hasDefined("search-dn")) {
            result.put("java.naming.security.principal", config.require("search-dn").asString());
        }
        if (config.hasDefined("search-credential")) {
            result.put("java.naming.security.credentials", config.require("search-credential").asString());
        }
        return result;
    }
}

