/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;

public class PrincipalAdd
implements OperationStepHandler {
    private final ConfigurableRoleMapper roleMapper;
    private final ConfigurableRoleMapper.MatchType matchType;

    private PrincipalAdd(ConfigurableRoleMapper roleMapper, ConfigurableRoleMapper.MatchType matchType) {
        this.roleMapper = roleMapper;
        this.matchType = matchType;
    }

    public static OperationStepHandler createForInclude(ConfigurableRoleMapper roleMapper) {
        return new PrincipalAdd(roleMapper, ConfigurableRoleMapper.MatchType.INCLUDE);
    }

    public static OperationStepHandler createForExclude(ConfigurableRoleMapper roleMapper) {
        return new PrincipalAdd(roleMapper, ConfigurableRoleMapper.MatchType.EXCLUDE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        PrincipalResourceDefinition.TYPE.validateAndSet(operation, model);
        PrincipalResourceDefinition.REALM.validateAndSet(operation, model);
        PrincipalResourceDefinition.NAME.validateAndSet(operation, model);
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        ConfigurableRoleMapper.PrincipalType principalType = PrincipalResourceDefinition.getPrincipalType(context, model);
        String realm = PrincipalResourceDefinition.getRealm(context, model);
        String name = PrincipalResourceDefinition.getName(context, model);
        this.registerRuntimeAdd(context, roleName, principalType, name, realm);
        context.stepCompleted();
    }

    private void registerRuntimeAdd(OperationContext context, final String roleName, final ConfigurableRoleMapper.PrincipalType principalType, final String name, final String realm) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!PrincipalAdd.this.roleMapper.addPrincipal(roleName, principalType, PrincipalAdd.this.matchType, name, realm, context.isBooting())) {
                    throw DomainManagementMessages.MESSAGES.inconsistentRbacRuntimeState();
                }
                PrincipalAdd.this.registerRollbackHandler(context, roleName, principalType, name, realm);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName, final ConfigurableRoleMapper.PrincipalType principalType, final String name, final String realm) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!PrincipalAdd.this.roleMapper.removePrincipal(roleName, principalType, PrincipalAdd.this.matchType, name, realm)) {
                    context.restartRequired();
                }
            }
        });
    }
}

