/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class IsCallerInRoleOperation
implements OperationStepHandler {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("is-caller-in-role", DomainManagementResolver.getResolver("core", "management", "access-control")).setReplyType(ModelType.BOOLEAN).setReadOnly().build();
    private final RoleMapper roleMapper;

    private IsCallerInRoleOperation(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        if (context.getCurrentStage() == OperationContext.Stage.MODEL) {
            context.addStep((OperationStepHandler)this, OperationContext.Stage.RUNTIME);
        } else {
            ModelNode result = context.getResult();
            Set roles = this.roleMapper.mapRoles(context.getCaller(), null, null, (TargetAttribute)null);
            result.set(roles.contains(roleName));
        }
        context.stepCompleted();
    }

    public static OperationStepHandler create(RoleMapper roleMapper) {
        return new IsCallerInRoleOperation(roleMapper);
    }
}

