/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class HostScopedRoleAdd
extends AbstractAddStepHandler {
    private final Map<String, HostEffectConstraint> constraintMap;
    private final ConfigurableAuthorizer authorizer;

    HostScopedRoleAdd(Map<String, HostEffectConstraint> constraintMap, ConfigurableAuthorizer authorizer) {
        super(new AttributeDefinition[]{HostScopedRolesResourceDefinition.BASE_ROLE, HostScopedRolesResourceDefinition.HOSTS});
        this.constraintMap = constraintMap;
        this.authorizer = authorizer;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String baseRole = HostScopedRolesResourceDefinition.BASE_ROLE.resolveModelAttribute(context, model).asString();
        ModelNode hostsAttribute = HostScopedRolesResourceDefinition.HOSTS.resolveModelAttribute(context, model);
        List nodeList = hostsAttribute.isDefined() ? hostsAttribute.asList() : Collections.emptyList();
        HostScopedRoleAdd.addScopedRole(roleName, baseRole, nodeList, this.authorizer, this.constraintMap);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.authorizer.removeScopedRole(roleName);
        this.constraintMap.remove(roleName);
    }

    static void addScopedRole(String roleName, String baseRole, List<ModelNode> hostNodes, ConfigurableAuthorizer authorizer, Map<String, HostEffectConstraint> constraintMap) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (ModelNode host : hostNodes) {
            hosts.add(host.asString());
        }
        HostEffectConstraint constraint = new HostEffectConstraint(hosts);
        authorizer.addScopedRole(roleName, baseRole, (ScopingConstraint)constraint);
        constraintMap.put(roleName, constraint);
    }
}

