/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ApplicationClassificationConfigResourceDefinition
extends SimpleResourceDefinition {
    public static PathElement PATH_ELEMENT = PathElement.pathElement((String)"classification");
    public static SimpleAttributeDefinition DEFAULT_APPLICATION = SimpleAttributeDefinitionBuilder.create((String)"default-application", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime().build();
    public static SimpleAttributeDefinition CONFIGURED_APPLICATION = SimpleAttributeDefinitionBuilder.create((String)"configured-application", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.APPLICATION.getLocalName()).build();

    ApplicationClassificationConfigResourceDefinition() {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.application-classification-config"));
    }

    static Resource.ResourceEntry createResource(ApplicationTypeConfig applicationType, String type, String name) {
        return ApplicationClassificationConfigResourceDefinition.createResource(applicationType, PathElement.pathElement((String)type, (String)name));
    }

    static Resource.ResourceEntry createResource(ApplicationTypeConfig applicationType, PathElement pathElement) {
        return new ApplicationTypeConfigResource(pathElement, applicationType);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_APPLICATION, (OperationStepHandler)ApplicationTypeConfigReadAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_APPLICATION, (OperationStepHandler)ApplicationTypeConfigReadAttributeHandler.INSTANCE, (OperationStepHandler)ApplicationTypeConfigWriteAttributeHandler.INSTANCE);
    }

    private static class ApplicationTypeConfigResource
    extends AbstractClassificationResource {
        private final ApplicationTypeConfig applicationType;

        ApplicationTypeConfigResource(PathElement pathElement, ApplicationTypeConfig classification) {
            super(pathElement);
            this.applicationType = classification;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            model.get(DEFAULT_APPLICATION.getName()).set(this.applicationType.isDefaultApplication());
            model.get(CONFIGURED_APPLICATION.getName()).set(this.getBoolean(this.applicationType.getConfiguredApplication()));
            return model;
        }

        private ModelNode getBoolean(Boolean booleanValue) {
            if (booleanValue == null) {
                return new ModelNode();
            }
            return new ModelNode(booleanValue.booleanValue());
        }

        public Set<String> getChildTypes() {
            return Collections.emptySet();
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return Collections.emptySet();
        }
    }

    private static class ApplicationTypeConfigWriteAttributeHandler
    implements OperationStepHandler {
        static final ApplicationTypeConfigWriteAttributeHandler INSTANCE = new ApplicationTypeConfigWriteAttributeHandler();

        private ApplicationTypeConfigWriteAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            ModelNode value = operation.require("value");
            ApplicationTypeConfigResource resource = (ApplicationTypeConfigResource)context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ApplicationTypeConfig classification = resource.applicationType;
            if (!attribute.equals(CONFIGURED_APPLICATION.getName())) {
                throw new IllegalStateException();
            }
            Boolean confValue = this.readValue(context, value, (AttributeDefinition)CONFIGURED_APPLICATION);
            classification.setConfiguredApplication(confValue);
            context.stepCompleted();
        }

        private Boolean readValue(OperationContext context, ModelNode value, AttributeDefinition definition) throws OperationFailedException {
            if (value.isDefined()) {
                return definition.resolveValue(context, value).asBoolean();
            }
            return null;
        }
    }

    private static class ApplicationTypeConfigReadAttributeHandler
    implements OperationStepHandler {
        static final ApplicationTypeConfigReadAttributeHandler INSTANCE = new ApplicationTypeConfigReadAttributeHandler();

        private ApplicationTypeConfigReadAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            ApplicationTypeConfigResource resource = (ApplicationTypeConfigResource)context.readResource(PathAddress.EMPTY_ADDRESS);
            ApplicationTypeConfig applicationType = resource.applicationType;
            Boolean result = null;
            if (attribute.equals(DEFAULT_APPLICATION.getName())) {
                result = applicationType.isDefaultApplication();
            } else if (attribute.equals(CONFIGURED_APPLICATION.getName())) {
                result = applicationType.getConfiguredApplication();
            } else {
                throw new IllegalStateException();
            }
            context.getResult();
            if (result != null) {
                context.getResult().set(result.booleanValue());
            }
            context.stepCompleted();
        }
    }
}

