/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.AbstractPlugInAuthResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ManagementXml {
    private final Delegate delegate;

    public ManagementXml(Delegate delegate) {
        this.delegate = delegate;
    }

    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean allowInterfaces, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseSecurityRealms(reader, managementAddress, expectedNs, list);
                    continue block5;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseConnections(reader, managementAddress, expectedNs, list);
                    continue block5;
                }
                case MANAGEMENT_INTERFACES: {
                    if (allowInterfaces) {
                        if (++managementInterfacesCount > 1) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        this.delegate.parseManagementInterfaces(reader, managementAddress, expectedNs, list);
                        continue block5;
                    }
                    DomainManagementLogger.ROOT_LOGGER.warn(ParseUtils.getWarningMessage((String)ControllerMessages.MESSAGES.elementNotSupported(element.getLocalName(), "domain.xml"), (Location)reader.getLocation()));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseConnections(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LDAP: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: 
                        case DOMAIN_1_3: {
                            this.parseLdapConnection_1_0(reader, address, list);
                            continue block6;
                        }
                    }
                    this.parseLdapConnection_1_4(reader, address, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnection_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL, Attribute.SEARCH_DN, Attribute.SEARCH_CREDENTIAL);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block7;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapConnection_1_4(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block8;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseSecurityRealm_1_0(reader, address, expectedNs, list);
                            continue block7;
                        }
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            this.parseSecurityRealm_1_1(reader, address, expectedNs, list);
                            continue block7;
                        }
                    }
                    this.parseSecurityRealm_1_3(reader, address, expectedNs, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication_1_0(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication_1_1(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization_1_1(reader, expectedNs, add, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_3(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    this.parsePlugIns(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication_1_3(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHORIZATION: {
                    switch (expectedNs) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: {
                            this.parseAuthorization_1_3(reader, expectedNs, add, list);
                            continue block9;
                        }
                    }
                    this.parseAuthorization_2_0(reader, expectedNs, add, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIns(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_IN: {
                    ModelNode plugIn = new ModelNode();
                    plugIn.get("operation").set("add");
                    String moduleValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.MODULE.getLocalName());
                    ModelNode newAddress = realmAddress.clone();
                    newAddress.add("plug-in", moduleValue);
                    plugIn.get("address").set(newAddress);
                    list.add(plugIn);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerIdentities(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    this.parseSecret(reader, realmAddress, list);
                    continue block4;
                }
                case SSL: {
                    this.parseSSL(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecret(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode secret = new ModelNode();
        secret.get("operation").set("add");
        secret.get("address").set(realmAddress).add("server-identity", "secret");
        String secretValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
        SecretServerIdentityResourceDefinition.VALUE.parseAndSetParameter(secretValue, secret, (XMLStreamReader)reader);
        list.add(secret);
    }

    private void parseSSL(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            this.parseKeystore_1_0(reader, ssl);
                            continue block10;
                        }
                    }
                    this.parseKeystore_1_3(reader, ssl, true);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeystore_1_0(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.PASSWORD);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore_1_3(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.KEYSTORE_PASSWORD);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PASSWORD: {
                    DomainManagementLogger.ROOT_LOGGER.passwordAttributeDeprecated();
                    required.remove(Attribute.KEYSTORE_PASSWORD);
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuthentication_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        int userCount = 0;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (++userCount > 1) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LDAP: {
                    this.parseLdapAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case PROPERTIES: {
                    this.parsePropertiesAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case USERS: {
                    this.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.addLegacyLocalAuthentication(realmAddress, list);
    }

    private void parseAuthentication_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean usernamePasswordFound = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLdapAuthentication_1_1(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, expectedNs, realmAddress, list);
                    trustStoreFound = true;
                    continue block7;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.addLegacyLocalAuthentication(realmAddress, list);
    }

    private void parseAuthentication_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean usernamePasswordFound = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block12;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (expectedNs) {
                        case DOMAIN_1_3: {
                            this.parseLdapAuthentication_1_1(reader, expectedNs, realmAddress, list);
                            break;
                        }
                        default: {
                            this.parseLdapAuthentication_1_4(reader, expectedNs, realmAddress, list);
                        }
                    }
                    usernamePasswordFound = true;
                    continue block12;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block12;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, expectedNs, realmAddress, list);
                    trustStoreFound = true;
                    continue block12;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block12;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    this.parsePlugIn_Authentication(reader, expectedNs, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block12;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLocalAuthentication(reader, expectedNs, realmAddress, list);
                    localFound = true;
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJaasAuthentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN, Attribute.USERNAME_ATTRIBUTE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USERNAME_ATTRIBUTE: {
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthentication_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean choiceFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private void parseLdapAuthentication_1_4(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean choiceFound = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block12;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private void addLegacyLocalAuthentication(ModelNode realmAddress, List<ModelNode> list) {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        local.get("default-user").set("$local");
        list.add(local);
    }

    private void parseLocalAuthentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePropertiesAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        properties.get("plain-text").set(true);
    }

    private void parsePropertiesAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case PLAIN_TEXT: {
                    PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseUsersAuthentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode usersAddress = realmAddress.clone().add("authentication", "users");
        list.add(Util.getEmptyOperation((String)"add", (ModelNode)usersAddress));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case USER: {
                    this.parseUser(reader, expectedNs, usersAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUser(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode usersAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode userAddress = usersAddress.clone().add("user", userName);
        ModelNode user = Util.getEmptyOperation((String)"add", (ModelNode)userAddress);
        list.add(user);
        String password = null;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PASSWORD: {
                    password = reader.getElementText();
                    UserResourceDefinition.PASSWORD.parseAndSetParameter(password, user, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (password == null) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.PASSWORD));
        }
    }

    private void parseTruststore(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(realmAddress).add("authentication", "truststore");
        switch (expectedNs) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: {
                this.parseKeystore_1_0(reader, op);
                break;
            }
            default: {
                this.parseKeystore_1_3(reader, op, true);
            }
        }
        list.add(op);
    }

    private void parseAuthorization_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        boolean authzFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        boolean authzFound = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block4;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, expectedNs, parentAddress, list);
                    authzFound = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAP_GROUPS_TO_ROLES: {
                    SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.parseAndSetParameter(value, realmAdd, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean authzFound = false;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block8;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, expectedNs, parentAddress, list);
                    authzFound = true;
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePropertiesAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthorizationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePlugIn_Authentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    PlugInAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    nameFound = true;
                    continue block10;
                }
                case MECHANISM: {
                    PlugInAuthenticationResourceDefinition.MECHANISM.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block12: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIn_Authorization(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String plugInName = reader.getAttributeValue(0);
        plugIn.get("name").set(plugInName);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block7: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        boolean addressFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(parentAddress).add("property", value);
                    addressFound = true;
                    continue block4;
                }
                case VALUE: {
                    PropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!addressFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        boolean hasInterface;
        boolean hasSecurityRealm = management.hasDefined("security-realm");
        boolean hasConnection = management.hasDefined("ldap-connection");
        boolean bl = hasInterface = allowInterfaces && management.hasDefined("management-interface");
        if (!(hasSecurityRealm || hasConnection || hasInterface)) {
            return;
        }
        writer.writeStartElement(Element.MANAGEMENT.getLocalName());
        if (hasSecurityRealm) {
            this.writeSecurityRealm(writer, management);
        }
        if (hasConnection) {
            this.writeOutboundConnections(writer, management);
        }
        if (allowInterfaces && hasInterface) {
            this.writeManagementInterfaces(writer, management);
        }
        writer.writeEndElement();
    }

    private void writeSecurityRealm(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        ModelNode securityRealms = management.get("security-realm");
        writer.writeStartElement(Element.SECURITY_REALMS.getLocalName());
        for (Property variable : securityRealms.asPropertyList()) {
            writer.writeStartElement(Element.SECURITY_REALM.getLocalName());
            ManagementXml.writeAttribute(writer, Attribute.NAME, variable.getName());
            ModelNode realm = variable.getValue();
            if (realm.hasDefined("plug-in")) {
                this.writePlugIns(writer, realm.get("plug-in"));
            }
            if (realm.hasDefined("server-identity")) {
                this.writeServerIdentities(writer, realm);
            }
            if (realm.hasDefined("authentication")) {
                this.writeAuthentication(writer, realm);
            }
            if (realm.hasDefined("authorization")) {
                this.writeAuthorization(writer, realm);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePlugIns(XMLExtendedStreamWriter writer, ModelNode plugIns) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_INS.getLocalName());
        for (Property variable : plugIns.asPropertyList()) {
            writer.writeEmptyElement(Element.PLUG_IN.getLocalName());
            writer.writeAttribute(Attribute.MODULE.getLocalName(), variable.getName());
        }
        writer.writeEndElement();
    }

    private void writeServerIdentities(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.SERVER_IDENTITIES.getLocalName());
        ModelNode serverIdentities = realm.get("server-identity");
        if (serverIdentities.hasDefined("ssl")) {
            writer.writeStartElement(Element.SSL.getLocalName());
            ModelNode ssl = serverIdentities.get("ssl");
            SSLServerIdentityResourceDefinition.PROTOCOL.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
            if (ssl.hasDefined(KeystoreAttributes.KEYSTORE_PATH.getName())) {
                writer.writeEmptyElement(Element.KEYSTORE.getLocalName());
                KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.ALIAS.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEY_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        if (serverIdentities.hasDefined("secret")) {
            ModelNode secret = serverIdentities.get("secret");
            writer.writeEmptyElement(Element.SECRET.getLocalName());
            SecretServerIdentityResourceDefinition.VALUE.marshallAsAttribute(secret, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
        ModelNode authentication = realm.require("authentication");
        if (authentication.hasDefined("truststore")) {
            ModelNode truststore = authentication.require("truststore");
            writer.writeEmptyElement(Element.TRUSTSTORE.getLocalName());
            KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
        }
        if (authentication.hasDefined("local")) {
            ModelNode local = authentication.require("local");
            writer.writeStartElement(Element.LOCAL.getLocalName());
            LocalAuthenticationResourceDefinition.DEFAULT_USER.marshallAsAttribute(local, (XMLStreamWriter)writer);
            LocalAuthenticationResourceDefinition.ALLOWED_USERS.marshallAsAttribute(local, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (authentication.hasDefined("jaas")) {
            ModelNode jaas = authentication.get("jaas");
            writer.writeStartElement(Element.JAAS.getLocalName());
            JaasAuthenticationResourceDefinition.NAME.marshallAsAttribute(jaas, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (authentication.hasDefined("ldap")) {
            ModelNode userLdap = authentication.get("ldap");
            writer.writeStartElement(Element.LDAP.getLocalName());
            LdapAuthenticationResourceDefinition.CONNECTION.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.BASE_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.RECURSIVE.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.USER_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            if (LdapAuthenticationResourceDefinition.USERNAME_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.USERNAME_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.USERNAME_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            } else if (LdapAuthenticationResourceDefinition.ADVANCED_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.ADVANCED_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.ADVANCED_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("properties")) {
            ModelNode properties = authentication.require("properties");
            writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
            PropertiesAuthenticationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.marshallAsAttribute(properties, (XMLStreamWriter)writer);
        } else if (authentication.hasDefined("users")) {
            ModelNode userDomain = authentication.get("users");
            ModelNode users = userDomain.hasDefined("user") ? userDomain.require("user") : new ModelNode().setEmptyObject();
            writer.writeStartElement(Element.USERS.getLocalName());
            for (Property userProps : users.asPropertyList()) {
                String userName = userProps.getName();
                ModelNode currentUser = userProps.getValue();
                writer.writeStartElement(Element.USER.getLocalName());
                writer.writeAttribute(Attribute.USERNAME.getLocalName(), userName);
                UserResourceDefinition.PASSWORD.marshallAsElement(currentUser, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("plug-in")) {
            this.writePlugIn_Authentication(writer, authentication.get("plug-in"));
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authentication(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        PlugInAuthenticationResourceDefinition.MECHANISM.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            for (Property current : plugIn.get("property").asPropertyList()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current.getName());
                PropertyResourceDefinition.VALUE.marshallAsAttribute(current.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
        SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.marshallAsAttribute(realm, (XMLStreamWriter)writer);
        ModelNode authorization = realm.require("authorization");
        if (authorization.hasDefined("properties")) {
            ModelNode properties = authorization.require("properties");
            writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
            PropertiesAuthorizationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthorizationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
        } else if (authorization.hasDefined("plug-in")) {
            this.writePlugIn_Authorization(writer, authorization.get("plug-in"));
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authorization(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            for (Property current : plugIn.get("property").asPropertyList()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current.getName());
                PropertyResourceDefinition.VALUE.marshallAsAttribute(current.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeOutboundConnections(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.OUTBOUND_CONNECTIONS.getLocalName());
        for (Property variable : management.get("ldap-connection").asPropertyList()) {
            ModelNode connection = variable.getValue();
            writer.writeEmptyElement(Element.LDAP.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
            LdapConnectionResourceDefinition.URL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_DN.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SECURITY_REALM.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.marshallAsAttribute(connection, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeManagementInterfaces(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
        ModelNode managementInterfaces = management.get("management-interface");
        if (managementInterfaces.hasDefined("native-remoting-interface")) {
            writer.writeEmptyElement(Element.NATIVE_REMOTING_INTERFACE.getLocalName());
        }
        if (managementInterfaces.hasDefined("native-interface")) {
            this.delegate.writeNativeManagementProtocol(writer, managementInterfaces.get("native-interface"));
        }
        if (managementInterfaces.hasDefined("http-interface")) {
            this.delegate.writeHttpManagementProtocol(writer, managementInterfaces.get("http-interface"));
        }
        writer.writeEndElement();
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    public static interface Delegate {
        public void parseManagementInterfaces(XMLExtendedStreamReader var1, ModelNode var2, Namespace var3, List<ModelNode> var4) throws XMLStreamException;

        public void writeNativeManagementProtocol(XMLExtendedStreamWriter var1, ModelNode var2) throws XMLStreamException;

        public void writeHttpManagementProtocol(XMLExtendedStreamWriter var1, ModelNode var2) throws XMLStreamException;
    }
}

