/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.as.domain.http.server.security.SecurityActions;
import org.jboss.as.domain.http.server.security.SubjectAccount;

public class SubjectAssociationHandler
implements HttpHandler {
    private final HttpHandler wrapped;

    public SubjectAssociationHandler(HttpHandler toWrap) {
        this.wrapped = toWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        try {
            Account account;
            if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) instanceof SubjectAccount) {
                SecurityActions.setSecurityContextSubject(((SubjectAccount)account).getSubject());
            }
            this.wrapped.handleRequest(exchange);
        }
        finally {
            SecurityActions.clearSubjectSecurityContext();
        }
    }
}

