/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;

public interface UnaryOperator<T>
extends java.util.function.UnaryOperator<T>,
Function<T, T> {
    public static final UnaryOperator<?> IDENTITY = new UnaryOperator<Object>(){

        @Override
        public Object apply(Object value) {
            return value;
        }
    };
    public static final UnaryOperator<?> NULL = new UnaryOperator<Object>(){

        @Override
        public Object apply(Object value) {
            return null;
        }
    };

    default public UnaryOperator<T> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultResult) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return predicate.test(value) ? UnaryOperator.this.apply(value) : defaultResult.get();
            }
        };
    }

    default public UnaryOperator<T> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return UnaryOperator.this.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public UnaryOperator<T> andThen(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return operator.apply(UnaryOperator.this.apply(value));
            }
        };
    }

    default public UnaryOperator<T> compose(final java.util.function.UnaryOperator<T> operator) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return UnaryOperator.this.apply(operator.apply(value));
            }
        };
    }

    default public UnaryOperator<T> handle(final BiFunction<T, RuntimeException, T> handler) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                try {
                    return UnaryOperator.this.apply(value);
                }
                catch (RuntimeException e) {
                    return handler.apply(value, e);
                }
            }
        };
    }

    public static <T> UnaryOperator<T> identity() {
        return IDENTITY;
    }

    public static <T> UnaryOperator<T> empty() {
        return NULL;
    }

    public static <T> UnaryOperator<T> of(final T value) {
        return value != null ? new UnaryOperator<T>(){

            @Override
            public T apply(T ignore) {
                return value;
            }
        } : UnaryOperator.empty();
    }

    public static <T> UnaryOperator<T> get(final java.util.function.Supplier<T> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new UnaryOperator<T>(){

            @Override
            public T apply(T ignore) {
                return supplier.get();
            }
        } : UnaryOperator.empty();
    }

    public static <T> UnaryOperator<T> apply(final java.util.function.Function<? super T, T> function) {
        return function != null && function != Function.NULL ? new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return function.apply(value);
            }
        } : UnaryOperator.empty();
    }
}

