/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Iterator;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class SubmitToThreadPool
implements MessageProcessingPolicy {
    protected TP tp;
    protected short tp_id;
    protected Log log;

    protected TP getTransport() {
        return this.tp;
    }

    @Override
    public void init(TP transport) {
        this.tp = transport;
        this.tp_id = this.tp.getId();
        this.log = this.tp.getLog();
    }

    @Override
    public boolean loopback(Message msg, boolean oob) {
        return this.tp.getThreadPool().execute(new SingleLoopbackHandler(msg));
    }

    @Override
    public boolean loopback(MessageBatch batch, boolean oob) {
        boolean removed;
        if (oob && (removed = this.removeAndDispatchNonBundledMessages(batch, true)) && batch.isEmpty()) {
            return true;
        }
        return this.tp.getThreadPool().execute(new BatchHandler(batch, true));
    }

    @Override
    public boolean process(Message msg, boolean oob) {
        return this.tp.getThreadPool().execute(new SingleMessageHandler(msg));
    }

    @Override
    public boolean process(MessageBatch batch, boolean oob) {
        boolean removed;
        if (oob && (removed = this.removeAndDispatchNonBundledMessages(batch, false)) && batch.isEmpty()) {
            return true;
        }
        return this.tp.getThreadPool().execute(new BatchHandler(batch, false));
    }

    protected boolean removeAndDispatchNonBundledMessages(MessageBatch oob_batch, boolean loopback) {
        if (oob_batch == null) {
            return false;
        }
        AsciiString tmp = oob_batch.clusterName();
        byte[] cname = tmp != null ? tmp.chars() : null;
        boolean removed = false;
        Iterator<Message> it = oob_batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (!msg.isFlagSet(Message.Flag.DONT_BUNDLE) || !msg.isFlagSet(Message.Flag.OOB)) continue;
            it.remove();
            Runnable handler = loopback ? new SingleLoopbackHandler(msg) : new SingleMessageHandlerWithClusterName(msg, cname);
            this.tp.getThreadPool().execute(handler);
            removed = true;
        }
        return removed;
    }

    public class BatchHandler
    implements Runnable {
        protected MessageBatch batch;
        protected boolean loopback;

        public BatchHandler(MessageBatch batch, boolean loopback) {
            this.batch = batch;
            this.loopback = loopback;
        }

        @Override
        public void run() {
            if (this.batch == null || this.batch.isEmpty() || !this.batch.multicast() && SubmitToThreadPool.this.tp.unicastDestMismatch(this.batch.dest())) {
                return;
            }
            this.passBatchUp();
        }

        protected void passBatchUp() {
            SubmitToThreadPool.this.tp.passBatchUp(this.batch, !this.loopback, !this.loopback);
        }
    }

    protected class SingleMessageHandlerWithClusterName
    extends SingleMessageHandler {
        protected final byte[] cluster;

        @Override
        protected byte[] getClusterName() {
            return this.cluster;
        }

        protected SingleMessageHandlerWithClusterName(Message msg, byte[] cluster_name) {
            super(msg);
            this.cluster = cluster_name;
        }
    }

    public class SingleMessageHandler
    implements Runnable {
        protected final Message msg;

        protected SingleMessageHandler(Message msg) {
            this.msg = msg;
        }

        public Message getMessage() {
            return this.msg;
        }

        @Override
        public void run() {
            Address dest = this.msg.getDest();
            boolean multicast = dest == null;
            try {
                byte[] cname = this.getClusterName();
                SubmitToThreadPool.this.tp.passMessageUp(this.msg, cname, true, multicast, true);
            }
            catch (Throwable t) {
                SubmitToThreadPool.this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }

        protected byte[] getClusterName() {
            TpHeader hdr = (TpHeader)this.msg.getHeader(SubmitToThreadPool.this.tp_id);
            return hdr.clusterName();
        }
    }

    public class SingleLoopbackHandler
    implements Runnable {
        protected final Message msg;

        public SingleLoopbackHandler(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            SubmitToThreadPool.this.tp.passMessageUp(this.msg, null, false, this.msg.getDest() == null, false);
        }
    }
}

