/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.httpclient.common.ConfigurationHttpContextSupplier;
import org.wildfly.httpclient.common.EENamespaceInteroperability;
import org.wildfly.httpclient.common.HostPool;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.httpclient.common.HttpConnectionPoolFactory;
import org.wildfly.httpclient.common.HttpContextGetterHolder;
import org.wildfly.httpclient.common.HttpMarshallerFactoryProvider;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class WildflyHttpContext
implements Contextual<WildflyHttpContext> {
    private static final int LEAK_DETECTION = Integer.getInteger("org.wildfly.http-client.buffer-leak-detection", 0);
    static ContextManager<WildflyHttpContext> HTTP_CONTEXT_MANAGER = AccessController.doPrivileged(() -> {
        ContextManager contextManager = new ContextManager(WildflyHttpContext.class, "jboss-ejb-http-client.http-context");
        contextManager.setGlobalDefaultSupplierIfNotSet(ConfigurationHttpContextSupplier::new);
        return contextManager;
    });
    private final Map<URI, HttpTargetContext> uriConnectionPools = new ConcurrentHashMap<URI, HttpTargetContext>();
    private final ConfigSection[] targets;
    private final int maxConnections;
    private final int maxStreamsPerConnection;
    private final long idleTimeout;
    private final boolean eagerlyAcquireAffinity;
    private final XnioWorker worker;
    private final ByteBufferPool pool;
    private final boolean enableHttp2;
    private final HttpConnectionPoolFactory httpConnectionPoolFactory;
    private final HttpMarshallerFactoryProvider httpMarshallerFactoryProvider;

    WildflyHttpContext(ConfigSection[] targets, int maxConnections, int maxStreamsPerConnection, long idleTimeout, boolean eagerlyAcquireAffinity, XnioWorker worker, ByteBufferPool pool, boolean enableHttp2, HttpConnectionPoolFactory httpConnectionPoolFactory, HttpMarshallerFactoryProvider httpMarshallerFactoryProvider) {
        this.targets = targets;
        this.maxConnections = maxConnections;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.idleTimeout = idleTimeout;
        this.eagerlyAcquireAffinity = eagerlyAcquireAffinity;
        this.worker = worker;
        this.pool = pool;
        this.enableHttp2 = enableHttp2;
        this.httpConnectionPoolFactory = httpConnectionPoolFactory;
        this.httpMarshallerFactoryProvider = httpMarshallerFactoryProvider;
    }

    public static WildflyHttpContext getCurrent() {
        return HttpContextGetterHolder.SUPPLIER.get();
    }

    public ContextManager<WildflyHttpContext> getInstanceContextManager() {
        return HTTP_CONTEXT_MANAGER;
    }

    public HttpTargetContext getTargetContext(URI uri) {
        return this.getConnectionPoolForURI(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpTargetContext getConnectionPoolForURI(URI uri) {
        HttpTargetContext context = this.uriConnectionPools.get(uri);
        if (context != null) {
            context.init();
            return context;
        }
        for (ConfigSection target : this.targets) {
            if (!target.getUri().equals(uri)) continue;
            target.getHttpTargetContext().init();
            this.uriConnectionPools.put(uri, target.getHttpTargetContext());
            return target.getHttpTargetContext();
        }
        WildflyHttpContext wildflyHttpContext = this;
        synchronized (wildflyHttpContext) {
            context = this.uriConnectionPools.get(uri);
            if (context != null) {
                return context;
            }
            HttpConnectionPool pool = this.httpConnectionPoolFactory.createHttpConnectionPool(this.maxConnections, this.maxStreamsPerConnection, this.worker, this.pool, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)this.enableHttp2), new HostPool(uri), this.idleTimeout);
            context = new HttpTargetContext(pool, this.eagerlyAcquireAffinity, uri, this.httpMarshallerFactoryProvider);
            this.uriConnectionPools.put(uri, context);
            context.init();
            return context;
        }
    }

    public static class BufferBuilder {
        private int bufferSize = 1024;
        private int maxSize = 100;
        private int threadLocalSize = 0;
        private boolean direct = true;

        public int getBufferSize() {
            return this.bufferSize;
        }

        public BufferBuilder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public BufferBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public int getThreadLocalSize() {
            return this.threadLocalSize;
        }

        public BufferBuilder setThreadLocalSize(int threadLocalSize) {
            this.threadLocalSize = threadLocalSize;
            return this;
        }

        public boolean isDirect() {
            return this.direct;
        }

        public BufferBuilder setDirect(boolean direct) {
            this.direct = direct;
            return this;
        }
    }

    static class Builder {
        private InetSocketAddress defaultBindAddress;
        private long idleTimeout = 50000L;
        private int maxConnections;
        private int maxStreamsPerConnection;
        private Boolean eagerlyAcquireSession;
        private final List<HttpConfigBuilder> targets = new ArrayList<HttpConfigBuilder>();
        private Boolean enableHttp2;
        private BufferBuilder bufferConfig;

        Builder() {
        }

        WildflyHttpContext build() {
            HttpMarshallerFactoryProvider httpMarshallerFactoryProvider;
            HttpConnectionPoolFactory httpConnectionPoolFactory;
            int maxStreamsPerConnection;
            XnioWorker worker = (XnioWorker)XnioWorker.getContextManager().get();
            DefaultByteBufferPool pool = this.bufferConfig == null ? new DefaultByteBufferPool(true, 1024, 100, 0, LEAK_DETECTION) : new DefaultByteBufferPool(this.bufferConfig.isDirect(), this.bufferConfig.getBufferSize(), this.bufferConfig.getMaxSize(), this.bufferConfig.getThreadLocalSize(), LEAK_DETECTION);
            ConfigSection[] connections = new ConfigSection[this.targets.size()];
            long idleTimout = this.idleTimeout > 0L ? this.idleTimeout : 60000L;
            int maxConnections = this.maxConnections > 0 ? this.maxConnections : 10;
            int n = maxStreamsPerConnection = this.maxStreamsPerConnection > 0 ? this.maxStreamsPerConnection : 10;
            if (EENamespaceInteroperability.EE_NAMESPACE_INTEROPERABLE_MODE) {
                httpConnectionPoolFactory = EENamespaceInteroperability.getHttpConnectionPoolFactory();
                httpMarshallerFactoryProvider = EENamespaceInteroperability.getHttpMarshallerFactoryProvider();
            } else {
                httpConnectionPoolFactory = HttpConnectionPoolFactory.getDefault();
                httpMarshallerFactoryProvider = HttpMarshallerFactoryProvider.getDefaultHttpMarshallerFactoryProvider();
            }
            for (int i = 0; i < this.targets.size(); ++i) {
                ConfigSection connection;
                boolean http2;
                boolean eager;
                HttpConfigBuilder sb = this.targets.get(i);
                HostPool hp = new HostPool(sb.getUri());
                boolean bl = eager = this.eagerlyAcquireSession == null ? false : this.eagerlyAcquireSession;
                if (sb.getEagerlyAcquireSession() != null && sb.getEagerlyAcquireSession().booleanValue()) {
                    eager = true;
                }
                boolean bl2 = http2 = this.enableHttp2 == null ? true : this.enableHttp2;
                if (sb.getEnableHttp2() != null) {
                    http2 = sb.getEnableHttp2();
                }
                connections[i] = connection = new ConfigSection(new HttpTargetContext(httpConnectionPoolFactory.createHttpConnectionPool(sb.getMaxConnections() > 0 ? sb.getMaxConnections() : maxConnections, sb.getMaxStreamsPerConnection() > 0 ? sb.getMaxStreamsPerConnection() : maxStreamsPerConnection, worker, (ByteBufferPool)pool, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)http2), hp, sb.getIdleTimeout() > 0L ? sb.getIdleTimeout() : idleTimout), eager, sb.getUri(), httpMarshallerFactoryProvider), sb.getUri());
            }
            return new WildflyHttpContext(connections, maxConnections, maxStreamsPerConnection, this.idleTimeout, this.eagerlyAcquireSession == null ? false : this.eagerlyAcquireSession, worker, (ByteBufferPool)pool, this.enableHttp2 == null ? true : this.enableHttp2, httpConnectionPoolFactory, httpMarshallerFactoryProvider);
        }

        void setDefaultBindAddress(InetSocketAddress defaultBindAddress) {
            this.defaultBindAddress = defaultBindAddress;
        }

        InetSocketAddress getDefaultBindAddress() {
            return this.defaultBindAddress;
        }

        HttpConfigBuilder addConfig(URI uri) {
            HttpConfigBuilder builder = new HttpConfigBuilder(uri);
            this.targets.add(builder);
            return builder;
        }

        List<HttpConfigBuilder> getTargets() {
            return this.targets;
        }

        long getIdleTimeout() {
            return this.idleTimeout;
        }

        void setIdleTimeout(long idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        int getMaxConnections() {
            return this.maxConnections;
        }

        void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        int getMaxStreamsPerConnection() {
            return this.maxStreamsPerConnection;
        }

        void setMaxStreamsPerConnection(int maxStreamsPerConnection) {
            this.maxStreamsPerConnection = maxStreamsPerConnection;
        }

        Boolean getEagerlyAcquireSession() {
            return this.eagerlyAcquireSession;
        }

        void setEagerlyAcquireSession(Boolean eagerlyAcquireSession) {
            this.eagerlyAcquireSession = eagerlyAcquireSession;
        }

        public BufferBuilder getBufferConfig() {
            return this.bufferConfig;
        }

        public Builder setBufferConfig(BufferBuilder bufferConfig) {
            this.bufferConfig = bufferConfig;
            return this;
        }

        public void setEnableHttp2(Boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
        }

        public Boolean getEnableHttp2() {
            return this.enableHttp2;
        }

        class HttpConfigBuilder {
            final URI uri;
            private InetSocketAddress bindAddress;
            private long idleTimeout;
            private int maxConnections;
            private int maxStreamsPerConnection;
            private Boolean eagerlyAcquireSession;
            private Boolean enableHttp2;

            HttpConfigBuilder(URI uri) {
                this.uri = uri;
            }

            public URI getUri() {
                return this.uri;
            }

            void setBindAddress(InetSocketAddress bindAddress) {
                this.bindAddress = bindAddress;
            }

            InetSocketAddress getBindAddress() {
                return this.bindAddress;
            }

            long getIdleTimeout() {
                return this.idleTimeout;
            }

            void setIdleTimeout(long idleTimeout) {
                this.idleTimeout = idleTimeout;
            }

            int getMaxConnections() {
                return this.maxConnections;
            }

            void setMaxConnections(int maxConnections) {
                this.maxConnections = maxConnections;
            }

            int getMaxStreamsPerConnection() {
                return this.maxStreamsPerConnection;
            }

            void setMaxStreamsPerConnection(int maxStreamsPerConnection) {
                this.maxStreamsPerConnection = maxStreamsPerConnection;
            }

            Boolean getEagerlyAcquireSession() {
                return this.eagerlyAcquireSession;
            }

            void setEagerlyAcquireSession(Boolean eagerlyAcquireSession) {
                this.eagerlyAcquireSession = eagerlyAcquireSession;
            }

            public void setEnableHttp2(Boolean enableHttp2) {
                this.enableHttp2 = enableHttp2;
            }

            public Boolean getEnableHttp2() {
                return this.enableHttp2;
            }
        }
    }

    static class ConfigSection {
        private final HttpTargetContext httpTargetContext;
        private final URI uri;

        ConfigSection(HttpTargetContext httpTargetContext, URI uri) {
            this.httpTargetContext = httpTargetContext;
            this.uri = uri;
        }

        public HttpTargetContext getHttpTargetContext() {
            return this.httpTargetContext;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

