/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.reactive.messaging.connector.InboundConnector;
import io.smallrye.reactive.messaging.connector.OutboundConnector;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.ConnectorLiteral;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class ConnectorFactories {
    private final Map<String, InboundConnector> inbound;
    private final Map<String, OutboundConnector> outbound;

    protected ConnectorFactories() {
        this.inbound = null;
        this.outbound = null;
    }

    @Inject
    public ConnectorFactories(@Any Instance<InboundConnector> inc, @Any Instance<IncomingConnectorFactory> incFactories, @Any Instance<OutboundConnector> out, @Any Instance<OutgoingConnectorFactory> outFactories, BeanManager beanManager) {
        this.inbound = new HashMap<String, InboundConnector>();
        this.outbound = new HashMap<String, OutboundConnector>();
        beanManager.getBeans(InboundConnector.class, new Annotation[]{Any.Literal.INSTANCE}).forEach(bean -> {
            String connector = this.extractConnector((Bean<?>)bean);
            InboundConnector instance = (InboundConnector)inc.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).get();
            this.addToMap(this.inbound, connector, instance);
        });
        beanManager.getBeans(IncomingConnectorFactory.class, new Annotation[]{Any.Literal.INSTANCE}).forEach(bean -> {
            String connector = this.extractConnector((Bean<?>)bean);
            InboundConnector instance = this.wrap((IncomingConnectorFactory)incFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).get());
            this.addToMap(this.inbound, connector, instance);
        });
        beanManager.getBeans(OutboundConnector.class, new Annotation[]{Any.Literal.INSTANCE}).forEach(bean -> {
            String connector = this.extractConnector((Bean<?>)bean);
            OutboundConnector instance = (OutboundConnector)out.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).get();
            this.addToMap(this.outbound, connector, instance);
        });
        beanManager.getBeans(OutgoingConnectorFactory.class, new Annotation[]{Any.Literal.INSTANCE}).forEach(bean -> {
            String connector = this.extractConnector((Bean<?>)bean);
            OutboundConnector instance = this.wrap((OutgoingConnectorFactory)outFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).get());
            this.addToMap(this.outbound, connector, instance);
        });
    }

    private <T> void addToMap(Map<String, T> map, String key, T instance) {
        T old = map.put(key, instance);
        if (old != null) {
            throw ProviderExceptions.ex.multipleBeanDeclaration(key, old.getClass().getName(), instance.getClass().getName());
        }
    }

    private InboundConnector wrap(IncomingConnectorFactory cf) {
        return config -> AdaptersToFlow.publisher((Publisher)cf.getPublisherBuilder(config).buildRs());
    }

    private OutboundConnector wrap(OutgoingConnectorFactory cf) {
        return config -> AdaptersToFlow.subscriber((Subscriber)cf.getSubscriberBuilder(config).build());
    }

    private String extractConnector(Bean<?> bean) {
        return bean.getQualifiers().stream().filter(a -> a.annotationType().equals(Connector.class)).map(annotation -> ((Connector)annotation).value()).findAny().orElseThrow(() -> ProviderExceptions.ex.missingConnectorQualifier(bean.getBeanClass().getName()));
    }

    public Map<String, InboundConnector> getInboundConnectors() {
        return this.inbound;
    }

    public Map<String, OutboundConnector> getOutboundConnectors() {
        return this.outbound;
    }
}

