/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

public class SarLogger_$logger
extends DelegatingBasicLogger
implements SarLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SarLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public SarLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String failedExecutingLegacyMethod$str() {
        return "WFLYSAR0001: Failed to execute legacy service %s method";
    }

    @Override
    public final String failedExecutingLegacyMethod(String methodName) {
        return String.format(this.getLoggingLocale(), this.failedExecutingLegacyMethod$str(), methodName);
    }

    @Override
    public final void propertyNotFound(Class<?> type) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.propertyNotFound$str(), type);
    }

    protected String propertyNotFound$str() {
        return "WFLYSAR0002: Unable to find PropertyEditor for type %s";
    }

    protected String classNotFound$str() {
        return "WFLYSAR0003: Class not found";
    }

    @Override
    public final IllegalArgumentException classNotFound(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classNotFound$str(), new Object[0]), cause);
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String classNotInstantiated$str() {
        return "WFLYSAR0004: Class not instantiated";
    }

    @Override
    public final IllegalArgumentException classNotInstantiated(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classNotInstantiated$str(), new Object[0]), cause);
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToGetAttachment$str() {
        return "WFLYSAR0005: Failed to get %s attachment for %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToGetAttachment(String attachmentType, DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToGetAttachment$str(), attachmentType, deploymentUnit));
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedXmlParsing$str() {
        return "WFLYSAR0006: Failed to parse service xml [%s]";
    }

    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedXmlParsing$str(), xmlFile));
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final DeploymentUnitProcessingException failedXmlParsing(Throwable cause, VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedXmlParsing$str(), xmlFile), cause);
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String methodNotFound$str() {
        return "WFLYSAR0007: Method '%s(%s)' not found for: %s";
    }

    @Override
    public final IllegalStateException methodNotFound(String methodName, String methodParams, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotFound$str(), methodName, methodParams, className));
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredAttributes$str() {
        return "WFLYSAR0008: Missing one or more required attributes:";
    }

    @Override
    public final String missingRequiredAttributes() {
        return String.format(this.getLoggingLocale(), this.missingRequiredAttributes$str(), new Object[0]);
    }

    protected String nullVar$str() {
        return "WFLYSAR0009: %s is null";
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), name));
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyMethodNotFound$str() {
        return "WFLYSAR0010: %s method for property '%s' not found for: %s";
    }

    @Override
    public final IllegalStateException propertyMethodNotFound(String methodPrefix, String propertyName, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.propertyMethodNotFound$str(), methodPrefix, propertyName, className));
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedContent$str() {
        return "WFLYSAR0011: Unexpected content of type '%s' named '%s', text is: %s";
    }

    @Override
    public final String unexpectedContent(String kind, QName name, String text) {
        return String.format(this.getLoggingLocale(), this.unexpectedContent$str(), kind, name, text);
    }

    protected String failedToProcessSarChild$str() {
        return "WFLYSAR0012: Failed to process SAR child archives for [%s]";
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessSarChild(Throwable cause, VirtualFile deploymentRoot) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessSarChild$str(), deploymentRoot), cause);
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String malformedDependencyName$str() {
        return "WFLYSAR0013: Malformed dependency name %s";
    }

    @Override
    public final DeploymentUnitProcessingException malformedDependencyName(Throwable cause, String dependencyName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.malformedDependencyName$str(), dependencyName), cause);
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String defaultConstructorNotFound$str() {
        return "WFLYSAR0014: Could not find default constructor for %s";
    }

    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFound(Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultConstructorNotFound$str(), clazz));
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String mbeanRegistrationFailed$str() {
        return "WFLYSAR0015: Failed to register mbean [%s]";
    }

    @Override
    public final StartException mbeanRegistrationFailed(Throwable cause, String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.mbeanRegistrationFailed$str(), name), cause);
        SarLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void cannotUnregisterObject() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotUnregisterObject$str(), new Object[0]);
    }

    protected String cannotUnregisterObject$str() {
        return "WFLYSAR0016: No ObjectName available to unregister";
    }

    @Override
    public final void unregistrationFailure(Throwable cause, ObjectName name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unregistrationFailure$str(), (Object)name);
    }

    protected String unregistrationFailure$str() {
        return "WFLYSAR0017: Failed to unregister [%s]";
    }

    protected String objectSupplierNotAvailable$str() {
        return "WFLYSAR0018: Object supplier not available";
    }

    @Override
    public final IllegalStateException objectSupplierNotAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.objectSupplierNotAvailable$str(), new Object[0]));
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String objectNotAvailable$str() {
        return "WFLYSAR0019: Object not available";
    }

    @Override
    public final IllegalStateException objectNotAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.objectNotAvailable$str(), new Object[0]));
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodIsNotAccessible$str() {
        return "WFLYSAR0020: Method is not accessible";
    }

    @Override
    public final IllegalStateException methodIsNotAccessible(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodIsNotAccessible$str(), new Object[0]), cause);
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInvokeMethod$str() {
        return "WFLYSAR0021: Failed to invoke method";
    }

    @Override
    public final IllegalStateException failedToInvokeMethod(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToInvokeMethod$str(), new Object[0]), cause);
        SarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

