/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.vertx.mutiny.core.Vertx;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.apache.kafka.common.TopicPartition;

@Experimental(value="Experimental API")
public interface KafkaCommitHandler {
    default public <K, V> Uni<IncomingKafkaRecord<K, V>> received(IncomingKafkaRecord<K, V> record) {
        return Uni.createFrom().item(record);
    }

    default public void terminate(boolean graceful) {
    }

    default public void partitionsAssigned(Collection<TopicPartition> partitions) {
    }

    default public void partitionsRevoked(Collection<TopicPartition> partitions) {
    }

    public <K, V> Uni<Void> handle(IncomingKafkaRecord<K, V> var1);

    public static interface Factory {
        public KafkaCommitHandler create(KafkaConnectorIncomingConfiguration var1, Vertx var2, KafkaConsumer<?, ?> var3, BiConsumer<Throwable, Boolean> var4);
    }

    public static interface Strategy {
        public static final String LATEST = "latest";
        public static final String IGNORE = "ignore";
        public static final String THROTTLED = "throttled";
        public static final String CHECKPOINT = "checkpoint";
    }
}

