/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.cloner;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.CloneTable;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;

class CloneableCloner
implements ObjectCloner {
    private final CloneTable cloneTable;
    private static final Method CLONE = System.getSecurityManager() == null ? GetCloneMethodAction.INSTANCE.run() : AccessController.doPrivileged(GetCloneMethodAction.INSTANCE);
    private final IdentityHashMap<Object, Object> clones = new IdentityHashMap();

    CloneableCloner(ClonerConfiguration configuration) {
        CloneTable cloneTable = configuration.getCloneTable();
        this.cloneTable = cloneTable == null ? CloneTable.NULL : cloneTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CloneableCloner cloneableCloner = this;
        synchronized (cloneableCloner) {
            this.clones.clear();
        }
    }

    @Override
    public Object clone(Object orig) throws IOException, ClassNotFoundException {
        CloneableCloner cloneableCloner = this;
        synchronized (cloneableCloner) {
            if (orig == null) {
                return null;
            }
            Object cached = this.clones.get(orig);
            if (cached != null) {
                return cached;
            }
            cached = this.cloneTable.clone(orig, this, ClassCloner.IDENTITY);
            if (cached != null) {
                this.clones.put(orig, cached);
                return cached;
            }
            try {
                Object clone = CLONE.invoke(orig, new Object[0]);
                this.clones.put(orig, clone);
                return clone;
            }
            catch (IllegalAccessException e) {
                throw new InvalidClassException(orig.getClass().getName(), "Can't access clone() method: " + String.valueOf(e));
            }
            catch (InvocationTargetException e) {
                throw new InvalidObjectException("Error invoking clone() method: " + String.valueOf(e));
            }
        }
    }

    private static final class GetCloneMethodAction
    implements PrivilegedAction<Method> {
        private static final PrivilegedAction<Method> INSTANCE = new GetCloneMethodAction();

        private GetCloneMethodAction() {
        }

        @Override
        public Method run() {
            Method method;
            try {
                method = Object.class.getDeclaredMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            method.setAccessible(true);
            return method;
        }
    }
}

