/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.registry;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceInstallerFactory;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class RegistryServiceInstallerFactory
implements BinaryServiceInstallerFactory<Registry<GroupMember, Object, Object>> {
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency registryFactory = configuration.getServiceDependency(ClusteringServiceDescriptor.REGISTRY_FACTORY);
        final ServiceDependency registryEntry = configuration.getServiceDependency(ClusteringServiceDescriptor.REGISTRY_ENTRY);
        Supplier<Registry<GroupMember, Object, Object>> factory = new Supplier<Registry<GroupMember, Object, Object>>(){

            @Override
            public Registry<GroupMember, Object, Object> get() {
                return ((RegistryFactory)registryFactory.get()).createRegistry((Map.Entry)registryEntry.get());
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).blocking()).onStop(Functions.closingConsumer())).provides(configuration.resolveServiceName(this.getServiceDescriptor()))).requires(List.of(registryFactory, registryEntry))).build();
    }

    public BinaryServiceDescriptor<Registry<GroupMember, Object, Object>> getServiceDescriptor() {
        return ClusteringServiceDescriptor.REGISTRY;
    }
}

