/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.FileAuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AbstractFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FileAuditLogHandlerResourceDefinition
extends AbstractFileAuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition ROTATE_AT_STARTUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-at-startup", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.TRUE)).build();
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ROTATE_AT_STARTUP};
    protected static final AttributeDefinition[] FULL_ATTRIBUTES = FileAuditLogHandlerResourceDefinition.joinArrays(ATTRIBUTES, AbstractFileAuditLogHandlerResourceDefinition.ATTRIBUTES);

    public FileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
        super(auditLogger, pathManager, PathElement.pathElement((String)"file-handler"), DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.file-handler"), (OperationStepHandler)new FileAuditLogHandlerAddHandler(auditLogger, pathManager), (OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger));
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : FULL_ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler write = this.getWriteAttributeHandler(this.auditLogger, this.pathManager);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    @Override
    protected AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler getWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
        return new FileAuditLogHandlerWriteAttributeHandler(auditLogger, pathManager);
    }

    private static FileAuditLogHandler createFileAuditLogHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String relativeTo = model.hasDefined(RELATIVE_TO.getName()) ? RELATIVE_TO.resolveModelAttribute(context, model).asString() : null;
        String path = PATH.resolveModelAttribute(context, model).asString();
        String formatterName = FORMATTER.resolveModelAttribute(context, model).asString();
        int maxFailureCount = MAX_FAILURE_COUNT.resolveModelAttribute(context, model).asInt();
        boolean rotateAtStartup = ROTATE_AT_STARTUP.resolveModelAttribute(context, model).asBoolean();
        return new FileAuditLogHandler(name, formatterName, maxFailureCount, pathManager, path, relativeTo, rotateAtStartup);
    }

    protected static class FileAuditLogHandlerAddHandler
    extends AbstractFileAuditLogHandlerResourceDefinition.AbstractFileAuditLogHandlerAddHandler {
        protected FileAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
            super(auditLogger, pathManager);
        }

        @Override
        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return FileAuditLogHandlerResourceDefinition.createFileAuditLogHandler(pathManager, context, operation);
        }
    }

    protected static class FileAuditLogHandlerWriteAttributeHandler
    extends AbstractFileAuditLogHandlerResourceDefinition.AbstractFileAuditLogHandlerWriteAttributeHandler {
        public FileAuditLogHandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
            super(auditLogger, pathManager);
        }

        @Override
        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return FileAuditLogHandlerResourceDefinition.createFileAuditLogHandler(pathManager, context, operation);
        }
    }
}

