/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.webservices11.wscoor.client.WSCOORClient;
import com.arjuna.wsc.CannotRegisterException;
import com.arjuna.wsc.InvalidProtocolException;
import com.arjuna.wsc.InvalidStateException;
import com.arjuna.wsc11.AsynchronousRegistrationMapper;
import com.arjuna.wsc11.FaultOrResponse;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.jboss.jbossts.xts.environment.WSCEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegisterType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.RegistrationPortType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class RegistrationCoordinator {
    public static W3CEndpointReference register(CoordinationContextType coordinationContext, String messageID, W3CEndpointReference participantProtocolService, String protocolIdentifier) throws CannotRegisterException, InvalidProtocolException, InvalidStateException, SoapFault {
        W3CEndpointReference endpointReference = coordinationContext.getRegistrationService();
        try {
            RegisterType registerType = new RegisterType();
            registerType.setProtocolIdentifier(protocolIdentifier);
            registerType.setParticipantProtocolService(participantProtocolService);
            RegistrationPortType port = WSCOORClient.getRegistrationPort(endpointReference, "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/Register", messageID);
            RegisterResponseType response = RegistrationCoordinator.registerOperation(messageID, port, registerType);
            return response.getCoordinatorProtocolService();
        }
        catch (SOAPFaultException sfe) {
            SOAPFault soapFault = sfe.getFault();
            Detail detail = soapFault.getDetail();
            String message = detail != null ? detail.getTextContent() : soapFault.getFaultString();
            RegistrationCoordinator.throwException(soapFault.getFaultCodeAsQName(), message, sfe, null);
            return null;
        }
    }

    private static void throwException(QName subcode, String detail, SOAPFaultException sfe, Fault fault) throws CannotRegisterException, InvalidProtocolException, InvalidStateException, SoapFault {
        if (CoordinationConstants.WSCOOR_ERROR_CODE_CANNOT_REGISTER_QNAME.equals(subcode)) {
            throw new CannotRegisterException(detail);
        }
        if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PROTOCOL_QNAME.equals(subcode)) {
            throw new InvalidProtocolException(detail);
        }
        if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME.equals(subcode)) {
            throw new InvalidStateException(detail);
        }
        if (sfe != null) {
            throw SoapFault11.create(sfe);
        }
        throw SoapFault11.fromFault(fault);
    }

    private static RegisterResponseType registerOperation(String messageID, final RegistrationPortType port, final RegisterType registerType) throws CannotRegisterException, InvalidProtocolException, InvalidStateException, SoapFault {
        WSCEnvironmentBean wscEnvironmentBean = XTSPropertyManager.getWSCEnvironmentBean();
        if (!"NO".equals(wscEnvironmentBean.getUseAsynchronousRequest())) {
            AsynchronousRegistrationMapper.getInstance().addClientMessage(messageID);
        }
        RegisterResponseType response = System.getSecurityManager() == null ? port.registerOperation(registerType) : AccessController.doPrivileged(new PrivilegedAction<RegisterResponseType>(){

            @Override
            public RegisterResponseType run() {
                return port.registerOperation(registerType);
            }
        });
        if (!"NO".equals(wscEnvironmentBean.getUseAsynchronousRequest())) {
            FaultOrResponse res = AsynchronousRegistrationMapper.getInstance().waitForResponse(messageID, wscEnvironmentBean.getAsyncRequestWait());
            if (res.isFault()) {
                String detail = res.getFault().getFaultstring();
                if (res.getFault().getDetail() != null && res.getFault().getDetail().getAny() != null && !res.getFault().getDetail().getAny().isEmpty()) {
                    detail = res.getFault().getDetail().getAny().get(0).toString();
                }
                RegistrationCoordinator.throwException(res.getFault().getFaultcode(), detail, null, res.getFault());
            } else if (res.isEmpty()) {
                throw new InvalidStateException("No response assigned to messageID " + messageID);
            }
            response = res.getResponse();
        }
        return response;
    }
}

