/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Dispatch;
import jakarta.xml.ws.Endpoint;
import jakarta.xml.ws.EndpointContext;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.spi.Invoker;
import jakarta.xml.ws.spi.ServiceDelegate;
import jakarta.xml.ws.spi.http.HttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.jboss.logging.Logger;
import org.jboss.ws.api.configuration.AbstractClientFeature;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.stack.cxf.client.ClientBusSelector;
import org.jboss.wsf.stack.cxf.client.SecurityActions;
import org.jboss.wsf.stack.cxf.client.TCCLAwareHandlerResolver;
import org.jboss.wsf.stack.cxf.client.configuration.CXFClientConfigurer;
import org.jboss.wsf.stack.cxf.client.configuration.HandlerChainSortInterceptor;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.i18n.Loggers;
import org.w3c.dom.Element;

public class ProviderImpl
extends org.apache.cxf.jaxws22.spi.ProviderImpl {
    protected EndpointImpl createEndpointImpl(Bus bus, String bindingId, Object implementor, WebServiceFeature ... features) {
        Boolean db = (Boolean)bus.getProperty("deployment-bus");
        if (db != null && db.booleanValue()) {
            Loggers.ROOT_LOGGER.cannotUseCurrentDepBusForStartingNewEndpoint();
            bus = BusFactory.newInstance().createBus();
        }
        return super.createEndpointImpl(bus, bindingId, implementor, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            this.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor, WebServiceFeature ... features) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            this.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Class<?> implementorClass, Invoker invoker, WebServiceFeature ... features) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            this.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementorClass, invoker, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        String busStrategy = ClientBusSelector.getInstance().selectStrategy(new WebServiceFeature[0]);
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        boolean restoreTCCL = false;
        Bus orig = null;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            orig = BusFactory.getThreadDefaultBus((boolean)false);
            Bus bus = this.getOrCreateBus(busStrategy, origClassLoader);
            JBossWSServiceImpl serviceDelegate = new JBossWSServiceImpl(bus, url, qname, cls, new WebServiceFeature[0]);
            this.setDisableCacheSchema(bus);
            JBossWSServiceImpl jBossWSServiceImpl = serviceDelegate;
            return jBossWSServiceImpl;
        }
        finally {
            this.restoreThreadDefaultBus(busStrategy, orig);
            if (restoreTCCL) {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass, WebServiceFeature ... features) {
        for (WebServiceFeature f : features) {
            String fName = f.getClass().getName();
            if (fName.startsWith("jakarta.xml.ws") || fName.startsWith("org.jboss.ws")) continue;
            throw org.jboss.wsf.stack.cxf.i18n.Messages.MESSAGES.unknownFeature(f.getClass().getName());
        }
        String busStrategy = ClientBusSelector.getInstance().selectStrategy(features);
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        boolean restoreTCCL = false;
        Bus orig = null;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            orig = BusFactory.getThreadDefaultBus((boolean)false);
            Bus bus = this.getOrCreateBus(busStrategy, origClassLoader);
            JBossWSServiceImpl serviceDelegate = new JBossWSServiceImpl(bus, wsdlDocumentLocation, serviceName, serviceClass, features);
            this.setDisableCacheSchema(bus);
            JBossWSServiceImpl jBossWSServiceImpl = serviceDelegate;
            return jBossWSServiceImpl;
        }
        finally {
            this.restoreThreadDefaultBus(busStrategy, orig);
            if (restoreTCCL) {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    private void setDisableCacheSchema(Bus bus) {
        if (bus.getExtension(WSDLManager.class) instanceof WSDLManagerImpl) {
            WSDLManagerImpl wsdlManangerImpl = (WSDLManagerImpl)bus.getExtension(WSDLManager.class);
            wsdlManangerImpl.setDisableSchemaCache(SecurityActions.getBoolean("org.jboss.ws.cxf.disableSchemaCache", true).booleanValue());
        }
    }

    private Bus getOrCreateBus(String strategy, ClassLoader threadContextClassLoader) {
        Bus bus = null;
        if ("THREAD_BUS".equals(strategy)) {
            bus = this.setValidThreadDefaultBus();
        } else if ("NEW_BUS".equals(strategy)) {
            bus = ClientBusSelector.getInstance().createNewBus();
            BusFactory.setThreadDefaultBus((Bus)bus);
        } else if ("TCCL_BUS".equals(strategy)) {
            bus = JBossWSBusFactory.getClassLoaderDefaultBus(threadContextClassLoader, ClientBusSelector.getInstance());
            BusFactory.setThreadDefaultBus((Bus)bus);
        }
        return bus;
    }

    private void restoreThreadDefaultBus(String busStrategy, Bus origBus) {
        if (origBus != null || !busStrategy.equals("THREAD_BUS")) {
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    static boolean checkAndFixContextClassLoader(ClassLoader origClassLoader) {
        try {
            origClassLoader.loadClass(ProviderImpl.class.getName());
        }
        catch (Exception e) {
            ClassLoader clientClassLoader = ProviderImpl.class.getClassLoader();
            if (BusFactory.getDefaultBus((boolean)false) == null) {
                JBossWSBusFactory.getDefaultBus(clientClassLoader);
            }
            SecurityActions.setContextClassLoader((ClassLoader)ProviderImpl.createDelegateClassLoader(clientClassLoader, origClassLoader));
            return true;
        }
        return false;
    }

    private Bus setValidThreadDefaultBus() {
        Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
        if (bus == null) {
            bus = ClientBusSelector.getInstance().createNewBus();
        }
        return bus;
    }

    private static DelegateClassLoader createDelegateClassLoader(final ClassLoader clientClassLoader, final ClassLoader origClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new DelegateClassLoader(clientClassLoader, origClassLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(clientClassLoader, origClassLoader);
            }
        });
    }

    static final class DelegateEndpointImpl
    extends Endpoint {
        private Endpoint delegate;

        public DelegateEndpointImpl(Endpoint delegate) {
            this.delegate = delegate;
        }

        public Binding getBinding() {
            return this.delegate.getBinding();
        }

        public Object getImplementor() {
            return this.delegate.getImplementor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(String address) {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(address);
            }
            finally {
                if (restoreTCCL) {
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(Object serverContext) {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(serverContext);
            }
            finally {
                if (restoreTCCL) {
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
        }

        public void stop() {
            this.delegate.stop();
        }

        public boolean isPublished() {
            return this.delegate.isPublished();
        }

        public List<Source> getMetadata() {
            return this.delegate.getMetadata();
        }

        public void setMetadata(List<Source> metadata) {
            this.delegate.setMetadata(metadata);
        }

        public Executor getExecutor() {
            return this.delegate.getExecutor();
        }

        public void setExecutor(Executor executor) {
            this.delegate.setExecutor(executor);
        }

        public Map<String, Object> getProperties() {
            return this.delegate.getProperties();
        }

        public void setProperties(Map<String, Object> properties) {
            this.delegate.setProperties(properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(referenceParameters);
                return endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(clazz, referenceParameters);
                return (T)endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    SecurityActions.setContextClassLoader(origClassLoader);
                }
            }
        }

        public void setEndpointContext(EndpointContext ctxt) {
            this.delegate.setEndpointContext(ctxt);
        }

        public void publish(HttpContext context) {
            this.delegate.publish(context);
        }
    }

    static final class JBossWSServiceImpl
    extends ServiceImpl {
        private final ConcurrentMap<Integer, SoftReference<Object>> portsCache = new ConcurrentHashMap<Integer, SoftReference<Object>>();

        public JBossWSServiceImpl(Bus b, URL url, QName name, Class<?> cls, WebServiceFeature ... f) {
            super(b, url, name, cls, f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
            Object port;
            int key = Objects.hash(portName, epr, serviceEndpointInterface, Arrays.hashCode(features));
            SoftReference ref = (SoftReference)this.portsCache.get(key);
            Object object = port = ref != null ? (Object)ref.get() : null;
            if (port == null) {
                Object newPort;
                ClassLoader origCL = SecurityActions.getContextClassLoader();
                DelegateClassLoader newCL = ProviderImpl.createDelegateClassLoader(origCL, SecurityActions.getClassLoader(ServiceImpl.class));
                try {
                    SecurityActions.setContextClassLoader((ClassLoader)newCL);
                    newPort = super.createPort(portName, epr, serviceEndpointInterface, features);
                }
                finally {
                    SecurityActions.setContextClassLoader(origCL);
                }
                this.setupClient(newPort, serviceEndpointInterface, features);
                SoftReference<Object> newRef = new SoftReference<Object>(newPort);
                SoftReference<Object> existingRef = this.portsCache.putIfAbsent(key, newRef);
                Object object2 = port = existingRef != null ? existingRef.get() : null;
                if (port == null) {
                    if (existingRef != null) {
                        this.portsCache.put(key, newRef);
                    }
                    port = newPort;
                }
            }
            return (T)port;
        }

        public void setHandlerResolver(HandlerResolver hr) {
            super.setHandlerResolver((HandlerResolver)new TCCLAwareHandlerResolver(hr));
        }

        public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
            Dispatch dispatch = super.createDispatch(portName, type, context, mode, features);
            this.setupClient(dispatch, null, features);
            return dispatch;
        }

        protected void setupClient(Object obj, Class<?> seiClass, WebServiceFeature ... features) {
            Binding binding = ((BindingProvider)obj).getBinding();
            Client client = obj instanceof DispatchImpl ? ((DispatchImpl)obj).getClient() : ClientProxy.getClient((Object)obj);
            ClientConfig config = JBossWSServiceImpl.readConfig(seiClass);
            if (config != null) {
                CXFClientConfigurer helper = new CXFClientConfigurer();
                helper.setupConfigHandlers(binding, (CommonConfig)config);
                helper.setConfigProperties(client, config.getProperties());
            }
            client.getOutInterceptors().add(new HandlerChainSortInterceptor(binding));
            if (features != null) {
                for (WebServiceFeature f : features) {
                    if (!(f instanceof AbstractClientFeature)) continue;
                    ((AbstractClientFeature)f).initialize(obj);
                }
            }
        }

        private static ServerConfig getServerConfig() {
            if (System.getSecurityManager() == null) {
                return AbstractServerConfig.getServerIntegrationServerConfig();
            }
            return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
        }

        private static ClientConfig readConfig(Class<?> seiClass) {
            ServerConfig sc;
            String configName;
            if (seiClass == null) {
                configName = null;
            } else {
                configName = seiClass.getName();
                InputStream is = null;
                try {
                    is = seiClass.getResourceAsStream("/jaxws-client-config.xml");
                    if (is != null) {
                        ClientConfig cc;
                        ConfigRoot config = ConfigMetaDataParser.parse((InputStream)is);
                        ClientConfig clientConfig = cc = config != null ? config.getClientConfigByName(configName) : null;
                        if (cc != null) {
                            ClientConfig clientConfig2 = cc;
                            return clientConfig2;
                        }
                    }
                }
                catch (Exception e) {
                    throw Messages.MESSAGES.couldNotReadConfiguration("jaxws-client-config.xml", (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(ProviderImpl.class).trace((Object)e);
                        }
                    }
                }
            }
            if (ClassLoaderProvider.isSet() && (sc = JBossWSServiceImpl.getServerConfig()) != null) {
                ClientConfig cf;
                ClientConfig clientConfig = cf = configName != null ? sc.getClientConfig(configName) : null;
                if (cf == null) {
                    cf = sc.getClientConfig("Standard-Client-Config");
                }
                if (cf != null) {
                    return cf;
                }
            }
            return null;
        }
    }
}

