/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementGroup;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.controller.xml.XMLParticleGroup;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;

public interface XMLSequence<RC, WC>
extends XMLParticleGroup<RC, WC> {

    public static class DefaultXMLSequence<RC, WC>
    extends XMLParticleGroup.DefaultXMLParticleGroup<RC, WC>
    implements XMLSequence<RC, WC> {
        private final List<QName> names;

        private static <RC, WC> Set<QName> collectNames(List<XMLParticleGroup<RC, WC>> groups) {
            TreeSet<QName> names = new TreeSet<QName>(QNameResolver.COMPARATOR);
            for (XMLParticleGroup<RC, WC> group : groups) {
                names.addAll(group.getReaderNames());
                if (!group.getCardinality().isRequired()) continue;
                break;
            }
            return Collections.unmodifiableSet(names);
        }

        protected DefaultXMLSequence(List<XMLParticleGroup<RC, WC>> groups, XMLCardinality cardinality) {
            this(DefaultXMLSequence.collectNames(groups), Collections.unmodifiableList(groups), cardinality);
        }

        private DefaultXMLSequence(Set<QName> names, final List<XMLParticleGroup<RC, WC>> groups, XMLCardinality cardinality) {
            super(names, groups, cardinality, new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    Assert.assertTrue((boolean)reader.isStartElement());
                    Iterator sequence = groups.iterator();
                    XMLParticleGroup group = null;
                    int occurrences = 0;
                    do {
                        if (group != null) {
                            if (!group.getReaderNames().contains(reader.getName())) {
                                if (occurrences < group.getCardinality().getMinOccurs()) {
                                    throw ParseUtils.minOccursNotReached(reader, group.getNames(), group.getCardinality());
                                }
                                group = this.findNext(reader, context, sequence);
                                occurrences = 0;
                            }
                        } else {
                            group = this.findNext(reader, context, sequence);
                        }
                        if (group == null) continue;
                        if (++occurrences > group.getCardinality().getMaxOccurs().orElse(Integer.MAX_VALUE)) {
                            throw ParseUtils.maxOccursExceeded(reader, group.getNames(), group.getCardinality());
                        }
                        group.getReader().readElement(reader, context);
                    } while (group != null && reader.getEventType() != 2);
                    while (sequence.hasNext()) {
                        group = sequence.next();
                        if (group.getCardinality().isRequired()) {
                            throw ParseUtils.minOccursNotReached(reader, group.getNames(), group.getCardinality());
                        }
                        group.getReader().whenAbsent(context);
                    }
                }

                @Override
                public void whenAbsent(RC context) {
                    for (XMLParticleGroup group : groups) {
                        group.getReader().whenAbsent(context);
                    }
                }

                private XMLParticleGroup<RC, WC> findNext(XMLExtendedStreamReader reader, RC context, Iterator<XMLParticleGroup<RC, WC>> remaining) throws XMLStreamException {
                    while (remaining.hasNext()) {
                        XMLParticleGroup group = remaining.next();
                        if (group.getReaderNames().contains(reader.getName())) {
                            return group;
                        }
                        if (group.getCardinality().isRequired()) {
                            throw ParseUtils.minOccursNotReached(reader, group.getNames(), group.getCardinality());
                        }
                        group.getReader().whenAbsent(context);
                    }
                    return null;
                }
            });
            this.names = groups.stream().map(XMLElementGroup::getNames).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public Collection<QName> getNames() {
            return this.names;
        }
    }

    public static class DefaultBuilder<RC, WC>
    extends XMLParticleGroup.AbstractBuilder<RC, WC, XMLElement<RC, WC>, XMLSequence<RC, WC>, Builder<RC, WC>>
    implements Builder<RC, WC> {
        DefaultBuilder(FeatureRegistry registry) {
            super(registry);
        }

        @Override
        public XMLSequence<RC, WC> build() {
            return new DefaultXMLSequence(this.getGroups(), this.getCardinality());
        }

        @Override
        protected Builder<RC, WC> builder() {
            return this;
        }
    }

    public static interface Builder<RC, WC>
    extends XMLParticleGroup.Builder<RC, WC, XMLElement<RC, WC>, XMLSequence<RC, WC>, Builder<RC, WC>> {
    }
}

