/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence.xml;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.xml.ResourceXMLElement;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface AttributeDefinitionXMLElement
extends ResourceXMLElement {

    public static class DefaultAttributeDefinitionXMLElement
    extends ResourceXMLElement.DefaultResourceXMLElement
    implements AttributeDefinitionXMLElement {
        DefaultAttributeDefinitionXMLElement(QName name, XMLCardinality cardinality, XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> reader, XMLContentWriter<ModelNode> writer, Stability stability) {
            super(name, cardinality, reader, writer, stability);
        }
    }

    public static class DefaultBuilder
    implements Builder {
        private final AttributeDefinition attribute;
        private final QNameResolver resolver;
        private volatile QName name = null;
        private volatile AttributeParser parser;
        private volatile AttributeMarshaller marshaller;

        DefaultBuilder(AttributeDefinition attribute, QNameResolver resolver) {
            this.attribute = attribute;
            this.resolver = resolver;
            this.parser = attribute.getParser();
            this.marshaller = attribute.getMarshaller();
        }

        @Override
        public Builder withLocalName(String localName) {
            return this.withName(this.resolver.resolve(localName));
        }

        @Override
        public Builder withName(QName name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder withParser(AttributeParser parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public Builder withMarshaller(AttributeMarshaller marshaller) {
            this.marshaller = marshaller;
            return this;
        }

        @Override
        public AttributeDefinitionXMLElement build() {
            final AttributeDefinition attribute = this.attribute;
            final AttributeParser parser = this.parser;
            final AttributeMarshaller marshaller = this.marshaller;
            QName name = this.name != null ? this.name : this.resolver.resolve(parser.getXmlName(attribute));
            XMLCardinality cardinality = parser.getCardinality(attribute);
            XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>> reader = new XMLElementReader<Map.Entry<PathAddress, Map<PathAddress, ModelNode>>>(){

                public void readElement(XMLExtendedStreamReader reader, Map.Entry<PathAddress, Map<PathAddress, ModelNode>> context) throws XMLStreamException {
                    PathAddress operationKey = context.getKey();
                    Map<PathAddress, ModelNode> operations = context.getValue();
                    ModelNode operation = operations.get(operationKey);
                    if (!parser.isParseAsElement()) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    parser.parseElement(attribute, reader, operation);
                }
            };
            XMLContentWriter<ModelNode> writer = new XMLContentWriter<ModelNode>(){

                public void writeContent(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
                    if (!this.isEmpty(model)) {
                        marshaller.marshallAsElement(attribute, model, true, (XMLStreamWriter)writer);
                    }
                }

                @Override
                public boolean isEmpty(ModelNode model) {
                    return !marshaller.isMarshallableAsElement() || !model.hasDefined(attribute.getName());
                }
            };
            return new DefaultAttributeDefinitionXMLElement(name, cardinality, reader, writer, attribute.getStability());
        }
    }

    public static interface Builder {
        public Builder withLocalName(String var1);

        public Builder withName(QName var1);

        public Builder withParser(AttributeParser var1);

        public Builder withMarshaller(AttributeMarshaller var1);

        public AttributeDefinitionXMLElement build();
    }
}

