/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.function.BiFunction;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.client.helpers.JBossModulesNameUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class ModuleIdentifierUtil {
    public static final ParameterCorrector MODULE_NAME_CORRECTOR = new ParameterCorrector(){

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            String corrected;
            String orig;
            if (ModelType.STRING.equals((Object)newValue.getType()) && !(orig = newValue.asString()).equals(corrected = ModuleIdentifierUtil.parseCanonicalModuleIdentifier(orig))) {
                newValue.set(corrected);
            }
            return newValue;
        }
    };

    @Deprecated(forRemoval=true, since="28.0.0")
    public static String canonicalModuleIdentifier(String moduleSpec) {
        return JBossModulesNameUtil.parseCanonicalModuleIdentifier((String)moduleSpec);
    }

    public static String parseCanonicalModuleIdentifier(String moduleSpec) {
        return JBossModulesNameUtil.parseCanonicalModuleIdentifier((String)moduleSpec);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function) {
        return (R)JBossModulesNameUtil.parseModuleIdentifier((String)moduleIdentifier, function, (boolean)false, null);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function, boolean canonicalize) {
        return (R)JBossModulesNameUtil.parseModuleIdentifier((String)moduleIdentifier, function, (boolean)canonicalize, null);
    }

    public static <R> R parseModuleIdentifier(String moduleIdentifier, BiFunction<String, String, R> function, boolean canonicalize, String defaultSlot) {
        return (R)JBossModulesNameUtil.parseModuleIdentifier((String)moduleIdentifier, function, (boolean)canonicalize, (String)defaultSlot);
    }

    public static String canonicalModuleIdentifier(String name, String slot) {
        return JBossModulesNameUtil.canonicalModuleIdentifier((String)name, (String)slot);
    }
}

