/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.ListenerRegistry;
import java.util.Collection;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.io.IOServiceDescriptor;
import org.wildfly.io.OptionAttributeDefinition;
import org.xnio.Option;

public class RemotingSubsystemRootResource
extends SimpleResourceDefinition {
    static final RuntimeCapability<Void> REMOTING_ENDPOINT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.remoting.endpoint", Endpoint.class).build();
    static final RuntimeCapability<Void> HTTP_LISTENER_REGISTRY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.remoting.http-listener-registry", ListenerRegistry.class).build();
    static final ModelNode LEGACY_DEFAULT_WORKER = new ModelNode("default");
    static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setRequired(false)).setAttributeGroup(Element.ENDPOINT.getLocalName())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setCapabilityReference(IOServiceDescriptor.WORKER.getName(), REMOTING_ENDPOINT_CAPABILITY)).build();
    private static final OptionAttributeDefinition SEND_BUFFER_SIZE = RemotingSubsystemRootResource.createOptionAttribute("send-buffer-size", RemotingOptions.SEND_BUFFER_SIZE, new ModelNode(8192));
    private static final OptionAttributeDefinition RECEIVE_BUFFER_SIZE = RemotingSubsystemRootResource.createOptionAttribute("receive-buffer-size", RemotingOptions.RECEIVE_BUFFER_SIZE, new ModelNode(8192));
    private static final OptionAttributeDefinition BUFFER_REGION_SIZE = RemotingSubsystemRootResource.createOptionAttribute("buffer-region-size", RemotingOptions.BUFFER_REGION_SIZE, null);
    private static final OptionAttributeDefinition TRANSMIT_WINDOW_SIZE = RemotingSubsystemRootResource.createOptionAttribute("transmit-window-size", RemotingOptions.TRANSMIT_WINDOW_SIZE, new ModelNode(131072));
    private static final OptionAttributeDefinition RECEIVE_WINDOW_SIZE = RemotingSubsystemRootResource.createOptionAttribute("receive-window-size", RemotingOptions.RECEIVE_WINDOW_SIZE, new ModelNode(131072));
    private static final OptionAttributeDefinition MAX_OUTBOUND_CHANNELS = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-channels", RemotingOptions.MAX_OUTBOUND_CHANNELS, new ModelNode(RemotingOptions.DEFAULT_MAX_OUTBOUND_CHANNELS));
    private static final OptionAttributeDefinition MAX_INBOUND_CHANNELS = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-channels", RemotingOptions.MAX_INBOUND_CHANNELS, new ModelNode(RemotingOptions.DEFAULT_MAX_INBOUND_CHANNELS));
    private static final OptionAttributeDefinition AUTHORIZE_ID = RemotingSubsystemRootResource.createOptionAttribute("authorize-id", RemotingOptions.AUTHORIZE_ID, null);
    private static final OptionAttributeDefinition AUTH_REALM = RemotingSubsystemRootResource.createOptionAttribute("auth-realm", RemotingOptions.AUTH_REALM, null);
    private static final OptionAttributeDefinition AUTHENTICATION_RETRIES = RemotingSubsystemRootResource.createOptionAttribute("authentication-retries", RemotingOptions.AUTHENTICATION_RETRIES, new ModelNode(3));
    private static final OptionAttributeDefinition MAX_OUTBOUND_MESSAGES = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-messages", RemotingOptions.MAX_OUTBOUND_MESSAGES, new ModelNode(65535));
    private static final OptionAttributeDefinition MAX_INBOUND_MESSAGES = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-messages", RemotingOptions.MAX_INBOUND_MESSAGES, new ModelNode(80));
    private static final OptionAttributeDefinition HEARTBEAT_INTERVAL = RemotingSubsystemRootResource.createOptionAttribute("heartbeat-interval", RemotingOptions.HEARTBEAT_INTERVAL, new ModelNode(60000));
    private static final OptionAttributeDefinition MAX_INBOUND_MESSAGE_SIZE = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-message-size", RemotingOptions.MAX_INBOUND_MESSAGE_SIZE, new ModelNode(Long.MAX_VALUE));
    private static final OptionAttributeDefinition MAX_OUTBOUND_MESSAGE_SIZE = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-message-size", RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE, new ModelNode(Long.MAX_VALUE));
    private static final OptionAttributeDefinition SERVER_NAME = RemotingSubsystemRootResource.createOptionAttribute("server-name", RemotingOptions.SERVER_NAME, null);
    static final OptionAttributeDefinition SASL_PROTOCOL = RemotingSubsystemRootResource.createOptionAttribute("sasl-protocol", RemotingOptions.SASL_PROTOCOL, new ModelNode("remote"));
    static final OptionAttributeDefinition[] OPTIONS = new OptionAttributeDefinition[]{SEND_BUFFER_SIZE, RECEIVE_BUFFER_SIZE, BUFFER_REGION_SIZE, TRANSMIT_WINDOW_SIZE, RECEIVE_WINDOW_SIZE, MAX_OUTBOUND_CHANNELS, MAX_INBOUND_CHANNELS, AUTHORIZE_ID, AUTH_REALM, AUTHENTICATION_RETRIES, MAX_OUTBOUND_MESSAGES, MAX_INBOUND_MESSAGES, HEARTBEAT_INTERVAL, MAX_INBOUND_MESSAGE_SIZE, MAX_OUTBOUND_MESSAGE_SIZE, SERVER_NAME, SASL_PROTOCOL};
    static final Collection<AttributeDefinition> ATTRIBUTES = Stream.concat(Stream.of(WORKER), Stream.of(OPTIONS)).collect(Collectors.toList());
    static final PathElement PATH = PathElement.pathElement((String)"subsystem", (String)"remoting");

    RemotingSubsystemRootResource() {
        super(new SimpleResourceDefinition.Parameters(PATH, RemotingExtension.getResourceDescriptionResolver("remoting")).setAddHandler((OperationStepHandler)new RemotingSubsystemAdd()).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{REMOTING_ENDPOINT_CAPABILITY, HTTP_LISTENER_REGISTRY_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)WORKER, null, (OperationStepHandler)new WorkerAttributeWriteHandler());
        for (OptionAttributeDefinition attribute : OPTIONS) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, ReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }

    private static OptionAttributeDefinition createOptionAttribute(String name, Option<?> option, ModelNode defaultValue) {
        OptionAttributeDefinition.Builder builder = (OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)name, option).setAllowExpression(true)).setAttributeGroup(Element.ENDPOINT.getLocalName())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
        if (defaultValue != null) {
            builder = (OptionAttributeDefinition.Builder)builder.setDefaultValue(defaultValue);
        }
        return builder.build();
    }

    private static class WorkerAttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler {
        private WorkerAttributeWriteHandler() {
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            context.addResponseWarning(Level.WARNING, RemotingLogger.ROOT_LOGGER.warningOnWorkerChange(newValue.asString()));
        }
    }
}

