/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.LinkedHashMap;
import java.util.Map;

class DefaultExponentialHistogramSnapShot
implements ExponentialHistogramSnapShot {
    private static final int MAX_ENTRIES = 50;
    private static final Map<Integer, ExponentialHistogramSnapShot> emptySnapshotCache = new LinkedHashMap<Integer, ExponentialHistogramSnapShot>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 50;
        }
    };
    private final int scale;
    private final long zeroCount;
    private final double zeroThreshold;
    private final ExponentialHistogramSnapShot.ExponentialBuckets positive;
    private final ExponentialHistogramSnapShot.ExponentialBuckets negative;

    DefaultExponentialHistogramSnapShot(int scale, long zeroCount, double zeroThreshold, ExponentialHistogramSnapShot.ExponentialBuckets positive, ExponentialHistogramSnapShot.ExponentialBuckets negative) {
        this.scale = scale;
        this.zeroCount = zeroCount;
        this.zeroThreshold = zeroThreshold;
        this.positive = positive;
        this.negative = negative;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public long zeroCount() {
        return this.zeroCount;
    }

    @Override
    public ExponentialHistogramSnapShot.ExponentialBuckets positive() {
        return this.positive;
    }

    @Override
    public ExponentialHistogramSnapShot.ExponentialBuckets negative() {
        return this.negative;
    }

    @Override
    public double zeroThreshold() {
        return this.zeroThreshold;
    }

    @Override
    public boolean isEmpty() {
        return this.positive.isEmpty() && this.negative.isEmpty() && this.zeroCount == 0L;
    }

    static ExponentialHistogramSnapShot getEmptySnapshotForScale(int scale) {
        return emptySnapshotCache.computeIfAbsent(scale, key -> new DefaultExponentialHistogramSnapShot((int)key, 0L, 0.0, ExponentialHistogramSnapShot.ExponentialBuckets.EMPTY_EXPONENTIAL_BUCKET, ExponentialHistogramSnapShot.ExponentialBuckets.EMPTY_EXPONENTIAL_BUCKET));
    }

    public String toString() {
        return "DefaultExponentialHistogramSnapShot{scale=" + this.scale() + ", zero_count=" + this.zeroCount() + ", zero_threshold=" + this.zeroThreshold + ", positive={" + this.positive + "}, negative={" + this.negative + "}";
    }
}

