/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.ExtendedOperatingSystemMBean;
import org.jboss.as.platform.mbean.OperatingSystemResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class OperatingSystemMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final OperatingSystemMXBeanAttributeHandler INSTANCE = new OperatingSystemMXBeanAttributeHandler();

    private OperatingSystemMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block4: {
            String name = operation.require("name").asString();
            try {
                if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_METRICS.contains(name)) {
                    OperatingSystemMXBeanAttributeHandler.storeResult(name, context.getResult());
                    break block4;
                }
                if (OperatingSystemResourceDefinition.OPERATING_SYSTEM_EXTENDED_METRICS.contains(name)) {
                    OperatingSystemMXBeanAttributeHandler.storeExtendedResult(name, context.getResult());
                    break block4;
                }
                throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
    }

    static void storeExtendedResult(String name, ModelNode store) {
        ExtendedOperatingSystemMBean ext = new ExtendedOperatingSystemMBean();
        if ("committed-virtual-memory-size".equals(name)) {
            if (ext.isAttributeDefined("CommittedVirtualMemorySize")) {
                store.set(ext.getCommittedVirtualMemorySize());
            }
        } else if ("free-memory-size".equals(name)) {
            if (ext.isAttributeDefined("FreeMemorySize")) {
                store.set(ext.getFreePhysicalMemorySize());
            }
        } else if ("free-swap-space-size".equals(name)) {
            if (ext.isAttributeDefined("FreeSwapSpaceSize")) {
                store.set(ext.getFreeSwapSpaceSize());
            }
        } else if ("process-cpu-load".equals(name)) {
            if (ext.isAttributeDefined("ProcessCpuLoad")) {
                store.set(ext.getProcessCpuLoad());
            }
        } else if ("process-cpu-time".equals(name)) {
            if (ext.isAttributeDefined("ProcessCpuTime")) {
                store.set(ext.getProcessCpuTime());
            }
        } else if ("cpu-load".equals(name)) {
            if (ext.isAttributeDefined("CpuLoad")) {
                store.set(ext.getSystemCpuLoad());
            }
        } else if ("total-memory-size".equals(name)) {
            if (ext.isAttributeDefined("TotalMemorySize")) {
                store.set(ext.getTotalPhysicalMemorySize());
            }
        } else if ("total-swap-space-size".equals(name)) {
            if (ext.isAttributeDefined("TotalSwapSpaceSize")) {
                store.set(ext.getTotalSwapSpaceSize());
            }
        } else if ("max-file-descriptor-count".equals(name)) {
            if (ext.isAttributeDefined("MaxFileDescriptorCount")) {
                store.set(ext.getMaxFileDescriptorCount());
            }
        } else if ("open-file-descriptor-count".equals(name)) {
            if (ext.isAttributeDefined("OpenFileDescriptorCount")) {
                store.set(ext.getOpenFileDescriptorCount());
            }
        } else if (OperatingSystemResourceDefinition.OPERATING_SYSTEM_EXTENDED_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.lang:type=OperatingSystem");
        } else if ("name".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getName());
        } else if ("arch".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getArch());
        } else if ("version".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getVersion());
        } else if ("available-processors".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        } else if ("system-load-average".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        } else if (OperatingSystemResourceDefinition.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }
}

