/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

public class MemoryPoolMXBeanResetPeakUsageHandler
implements OperationStepHandler {
    static final MemoryPoolMXBeanResetPeakUsageHandler INSTANCE = new MemoryPoolMXBeanResetPeakUsageHandler();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("reset-peak-usage", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("memory-pool")).setRuntimeOnly().build();

    private MemoryPoolMXBeanResetPeakUsageHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            this.getMemoryPoolMXBean(operation).resetPeakUsage();
        }
        catch (SecurityException e) {
            throw new OperationFailedException(e.toString());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private MemoryPoolMXBean getMemoryPoolMXBean(ModelNode operation) throws OperationFailedException {
        String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        MemoryPoolMXBean memoryPoolMXBean = null;
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memPoolName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName())) || !mbean.getObjectName().getKeyProperty("type").equals(PlatformMBeanConstants.MEMORY_POOL_TYPE)) continue;
            memoryPoolMXBean = mbean;
        }
        if (memoryPoolMXBean == null) {
            throw PlatformMBeanLogger.ROOT_LOGGER.unknownMemoryPool(memPoolName);
        }
        return memoryPoolMXBean;
    }
}

