/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.sfbasic;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.mechanism._private.ElytronMessages;

class IdentityManager {
    private static final long MAX_VALIDITY = 900000L;
    private final Random random = new SecureRandom();
    private final ScheduledExecutorService executor;
    private final Map<String, StoredIdentity> storedIdentities = new HashMap<String, StoredIdentity>();

    IdentityManager() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = executor;
    }

    synchronized String storeIdentity(String existingSessionID, CachedIdentity cachedIdentity) {
        StoredIdentity storedIdentity;
        if (existingSessionID != null && (storedIdentity = this.storedIdentities.get(existingSessionID)) != null) {
            storedIdentity.setCachedIdentity(cachedIdentity);
            storedIdentity.used(existingSessionID);
            ElytronMessages.httpBasic.tracef("Updating cached identity for session '%s'", (Object)existingSessionID);
            return existingSessionID;
        }
        String sessionID = null;
        while (sessionID == null || this.storedIdentities.containsKey(sessionID)) {
            sessionID = this.generateSessionID();
        }
        if (ElytronMessages.httpBasic.isTraceEnabled()) {
            ElytronMessages.httpBasic.tracef("Creating new session '%s' for identity '%s'.", (Object)sessionID, (Object)cachedIdentity.getName());
        }
        StoredIdentity toStore = new StoredIdentity(cachedIdentity);
        toStore.used(sessionID);
        this.storedIdentities.put(sessionID, toStore);
        return sessionID;
    }

    synchronized CachedIdentity retrieveIdentity(String sessionID) {
        StoredIdentity stored = this.storedIdentities.get(sessionID);
        if (stored != null) {
            if (System.currentTimeMillis() - stored.getLastAccessed() > 900000L) {
                ElytronMessages.httpBasic.tracef("Removing session '%s' due to request to use beyond validity period.", (Object)sessionID);
                stored.cancelCleanup();
                this.storedIdentities.remove(sessionID);
            } else {
                stored.used(sessionID);
                return stored.getCachedIdentity();
            }
        }
        return null;
    }

    synchronized CachedIdentity removeIdentity(String sessionID) {
        StoredIdentity stored = this.storedIdentities.remove(sessionID);
        if (stored != null) {
            stored.cancelCleanup();
            ElytronMessages.httpBasic.tracef("Removing session '%s' due to request to remove.", (Object)sessionID);
        }
        return stored != null ? stored.getCachedIdentity() : null;
    }

    private synchronized void evict(String sessionID, long forLastAccessed) {
        StoredIdentity stored = this.storedIdentities.get(sessionID);
        if (stored != null) {
            if (stored.getLastAccessed() == forLastAccessed) {
                this.storedIdentities.remove(sessionID);
                ElytronMessages.httpBasic.tracef("Removing session '%s' due to timeout.", (Object)sessionID);
            } else {
                ElytronMessages.httpBasic.tracef("Not evicting session '%s' due to different lastAccessed.", (Object)sessionID);
            }
        } else {
            ElytronMessages.httpBasic.tracef("Session '%s' due for eviction but not in the stored identities.", (Object)sessionID);
        }
    }

    private String generateSessionID() {
        byte[] rawId = new byte[32];
        this.random.nextBytes(rawId);
        return ByteIterator.ofBytes((byte[])rawId).base64Encode().drainToString();
    }

    void shutdown() {
        this.executor.shutdown();
    }

    private class StoredIdentity {
        private CachedIdentity cachedIdentity;
        private long lastAccessed;
        private ScheduledFuture<?> futureCleanup;

        StoredIdentity(CachedIdentity cachedIdentity) {
            this.cachedIdentity = cachedIdentity;
            this.lastAccessed = System.currentTimeMillis();
        }

        protected CachedIdentity getCachedIdentity() {
            return this.cachedIdentity;
        }

        void setCachedIdentity(CachedIdentity cachedIdentity) {
            this.cachedIdentity = cachedIdentity;
        }

        protected long getLastAccessed() {
            return this.lastAccessed;
        }

        void used(String sessionID) {
            this.cancelCleanup();
            long ourLastAccessed = this.lastAccessed = System.currentTimeMillis();
            this.futureCleanup = IdentityManager.this.executor.schedule(() -> IdentityManager.this.evict(sessionID, ourLastAccessed), 15L, TimeUnit.MINUTES);
        }

        void cancelCleanup() {
            if (this.futureCleanup != null) {
                this.futureCleanup.cancel(true);
                this.futureCleanup = null;
            }
        }
    }
}

