/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.bouncycastle.BouncyCastleEdDSASupport;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class BouncyCastleSecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String BCFIPS_PROVIDER_NAME = "BCFIPS";
    private static final String BC_PROVIDER_NAME = "BC";
    private static final String NAME_FIELD = "PROVIDER_NAME";
    private static final String EDDSA_KEY_CLASS_NAME = "org.bouncycastle.jcajce.interfaces.EdDSAKey";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);
    private final AtomicReference<String> allSupportHolder = new AtomicReference();
    private final AtomicReference<Boolean> edDSASupportHolder = new AtomicReference<Object>(null);
    private String providerClass;
    private String providerName;

    public BouncyCastleSecurityProviderRegistrar() {
        super(BC_PROVIDER_NAME);
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.getBooleanProperty("org.apache.sshd.registerBouncyCastle", true);
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(this.providerClass);
        }
        catch (ReflectiveOperationException t) {
            Throwable e = ExceptionUtils.peelException(t);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", this.getName(), e.getClass().getSimpleName(), this.providerClass, e.getMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        String allValue = this.allSupportHolder.get();
        if (GenericUtils.length(allValue) > 0) {
            return allValue;
        }
        String propName = this.getConfigurationPropertyName("supportAll");
        allValue = this.getStringProperty(propName, "all");
        if (GenericUtils.isEmpty(allValue)) {
            allValue = "none";
        }
        this.allSupportHolder.set(allValue);
        return allValue;
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType) ? Objects.compare(name, "EdDSA", String.CASE_INSENSITIVE_ORDER) == 0 && SecurityUtils.isNetI2pCryptoEdDSARegistered() : Signature.class.isAssignableFrom(entityType) && Objects.compare(name, "NONEwithEdDSA", String.CASE_INSENSITIVE_ORDER) == 0 && SecurityUtils.isNetI2pCryptoEdDSARegistered()) {
            return false;
        }
        return super.isSecurityEntitySupported(entityType, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            boolean requireFips = SecurityUtils.isFipsMode();
            Class<?> clazz = null;
            if (!requireFips) {
                clazz = ThreadUtils.resolveDefaultClass(this.getClass(), PROVIDER_CLASS);
            }
            if (clazz == null) {
                clazz = ThreadUtils.resolveDefaultClass(this.getClass(), FIPS_PROVIDER_CLASS);
            }
            if (clazz != null) {
                this.providerClass = clazz.getName();
                Provider provider = Security.getProvider(BCFIPS_PROVIDER_NAME);
                if (provider != null) {
                    this.providerName = BCFIPS_PROVIDER_NAME;
                } else if (!requireFips && (provider = Security.getProvider(BC_PROVIDER_NAME)) != null) {
                    this.providerName = BC_PROVIDER_NAME;
                }
                if (this.providerName == null) {
                    try {
                        Field f = clazz.getField(NAME_FIELD);
                        Object nameValue = f.get(null);
                        if (nameValue instanceof String) {
                            this.providerName = nameValue.toString();
                        }
                    }
                    catch (Exception e) {
                        this.log.warn("Alleged Bouncy Castle class {} has no {}; ignoring this provider.", this.providerClass, NAME_FIELD, e);
                    }
                }
                supported = this.providerName != null;
            } else {
                supported = Boolean.FALSE;
            }
            this.supportHolder.set(supported);
        }
        return supported;
    }

    @Override
    public Optional<EdDSASupport<?, ?>> getEdDSASupport() {
        if (!this.isEdDSASupported()) {
            return Optional.empty();
        }
        return Optional.of(new BouncyCastleEdDSASupport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEdDSASupported() {
        if (!this.isSupported()) {
            return false;
        }
        AtomicReference<Boolean> atomicReference = this.edDSASupportHolder;
        synchronized (atomicReference) {
            Boolean edDSASupported = this.edDSASupportHolder.get();
            if (edDSASupported != null) {
                return edDSASupported;
            }
            Class<?> clazz = ThreadUtils.resolveDefaultClass(this.getClass(), EDDSA_KEY_CLASS_NAME);
            edDSASupported = clazz != null;
            this.edDSASupportHolder.set(edDSASupported);
            return edDSASupported;
        }
    }
}

